/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class ByteArrayChannel
implements SeekableByteChannel {
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Set<? extends OpenOption> options;
    protected byte[] buf;
    private int pos;
    private int last;
    private boolean closed;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public ByteArrayChannel(byte[] buf, Set<? extends OpenOption> options) {
        this.options = options;
        this.buf = buf;
        this.pos = 0;
        this.last = buf.length;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public long position() throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            long l = this.pos;
            return l;
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public SeekableByteChannel position(long pos) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            if (pos < 0L || pos >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Illegal position " + pos);
            }
            this.pos = Math.min((int)pos, this.last);
            ByteArrayChannel byteArrayChannel = this;
            return byteArrayChannel;
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            if (this.pos == this.last) {
                return -1;
            }
            int n = Math.min(dst.remaining(), this.last - this.pos);
            dst.put(this.buf, this.pos, n);
            this.pos += n;
            int n2 = n;
            return n2;
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        this.ensureOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            int n = src.remaining();
            this.ensureCapacity(this.pos + n);
            src.get(this.buf, this.pos, n);
            this.pos += n;
            if (this.pos > this.last) {
                this.last = this.pos;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public long size() throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            long l = this.last;
            return l;
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.beginWrite();
        try {
            if (this.options.contains(StandardOpenOption.CREATE_NEW)) {
                this.createNewFile();
            }
            if (this.options.contains(StandardOpenOption.WRITE) && this.buf != null) {
                this.writeToFile();
            }
            if (this.options.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
                this.deleteFile();
            }
            this.closed = true;
            this.buf = null;
            this.pos = 0;
            this.last = 0;
        }
        finally {
            this.endWrite();
        }
    }

    protected abstract void createNewFile() throws IOException;

    protected abstract void writeToFile() throws IOException;

    protected abstract void deleteFile() throws IOException;

    public byte[] toByteArray() {
        this.beginRead();
        try {
            byte[] byArray = Arrays.copyOf(this.buf, this.last);
            return byArray;
        }
        finally {
            this.endRead();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    final void beginWrite() {
        this.rwlock.writeLock().lock();
    }

    final void endWrite() {
        this.rwlock.writeLock().unlock();
    }

    private final void beginRead() {
        this.rwlock.readLock().lock();
    }

    private final void endRead() {
        this.rwlock.readLock().unlock();
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteArrayChannel.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError("Required length exceeds implementation limit");
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

