/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizard;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorControl;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;

public class DCCompareTaskWizardPageObjects
extends ActiveWizardPage<DCCompareTaskWizard> {
    private static final Log log = Log.getLog(DCCompareTaskWizardPageObjects.class);
    private SelectorPanel leftSelectorPanel;
    private SelectorPanel rightSelectorPanel;

    protected DCCompareTaskWizardPageObjects() {
        super(DCMessages.data_compare_wizard_name);
        this.setTitle(DCMessages.data_compare_wizard_objects_title);
        this.setDescription(DCMessages.data_compare_wizard_objects_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        DBRRunnableContext runnableContext = ((DCCompareTaskWizard)this.getWizard()).getRunnableContext();
        this.leftSelectorPanel = new SelectorPanel(composite, DCMessages.data_compare_wizard_objects_first_container_title, runnableContext, () -> ((DCCompareTaskWizardPageObjects)this).updatePageCompletion());
        this.rightSelectorPanel = new SelectorPanel(composite, DCMessages.data_compare_wizard_objects_second_container_title, runnableContext, () -> ((DCCompareTaskWizardPageObjects)this).updatePageCompletion());
        this.setControl((Control)composite);
        UIUtils.asyncExec(() -> {
            DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
            if (settings.getLeftContainer() != null) {
                this.leftSelectorPanel.init(settings.getLeftContainer());
            }
            if (settings.getRightContainer() != null) {
                this.rightSelectorPanel.init(settings.getRightContainer());
            }
            this.updatePageCompletion();
        });
    }

    public void deactivatePage() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        settings.setLeftContainer(this.leftSelectorPanel.getActivePanel().extractContainer());
        settings.setRightContainer(this.rightSelectorPanel.getActivePanel().extractContainer());
    }

    protected boolean determinePageCompletion() {
        DataSourcePanel leftPanel = this.leftSelectorPanel.getActivePanel();
        DataSourcePanel rightPanel = this.rightSelectorPanel.getActivePanel();
        String panelError = leftPanel.getError();
        if (panelError == null) {
            panelError = rightPanel.getError();
        }
        if (panelError != null) {
            this.setErrorMessage(panelError);
            return false;
        }
        if (Objects.equals(leftPanel.extractContainer(), rightPanel.extractContainer())) {
            this.setErrorMessage(DCMessages.data_compare_wizard_objects_error_same_containers);
            return false;
        }
        return true;
    }

    public void performHelp() {
        ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-compare"));
    }

    private static interface DataSourcePanel {
        @NotNull
        public Control createControl(@NotNull Composite var1, @NotNull Runnable var2);

        public void loadContainer(@NotNull DBSDataContainer var1);

        @Nullable
        public DBSDataContainer extractContainer();

        @Nullable
        public String getError();
    }

    private static class QueryDataSourcePanel
    implements DataSourcePanel,
    IDocumentListener {
        private DBPDataSourceContainer dataSourceContainer;
        private Runnable changeNotifier;
        private SQLEditorBase editor;
        private Label containerIcon;
        private Text containerName;

        private QueryDataSourcePanel() {
        }

        @Override
        @NotNull
        public Control createControl(@NotNull Composite parent, @NotNull Runnable changeNotifier) {
            this.changeNotifier = changeNotifier;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).extendedMargins(0, 0, 5, 0).create());
            UIUtils.createControlLabel((Composite)composite, (String)DCMessages.data_compare_wizard_objects_connection_label);
            this.containerIcon = UIUtils.createLabel((Composite)composite, (DBPImage)DBIcon.TYPE_UNKNOWN);
            this.containerName = new Text(composite, 2056);
            this.containerName.setLayoutData((Object)new GridData(768));
            ToolBar toolBar = new ToolBar(composite, 0x800000);
            UIUtils.createToolItem((ToolBar)toolBar, (String)DCMessages.data_compare_wizard_objects_choose_data_source_tip, (DBPImage)DBIcon.TREE_FOLDER, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
                DBPDataSourceContainer selected = this.chooseDataSource();
                if (selected != null) {
                    this.setContainer(selected);
                    changeNotifier.run();
                }
            }));
            this.editor = new SQLEditorBase(){

                @Nullable
                public DBCExecutionContext getExecutionContext() {
                    return null;
                }
            };
            try {
                IWorkbenchPartSite site = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                this.editor.init((IEditorSite)new SubEditorSite(site), StringEditorInput.EMPTY_INPUT);
                this.editor.createPartControl(composite);
                this.editor.setWordWrap(true);
                this.setQuery(DCMessages.data_compare_wizard_objects_query_placeholder_text);
                SQLEditorControl control = this.editor.getEditorControlWrapper();
                control.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(4, 1).create());
            }
            catch (PartInitException e2) {
                DBWorkbench.getPlatformUI().showError("Create error", "Can't create SQL preview editor", (Throwable)e2);
            }
            return composite;
        }

        @Override
        public void loadContainer(@NotNull DBSDataContainer container) {
            this.setContainer(container.getDataSource().getContainer());
            if (container instanceof SQLQueryContainer) {
                SQLQueryContainer queryContainer = (SQLQueryContainer)container;
                this.setQuery(queryContainer.getQuery().getText());
            }
        }

        @Override
        @Nullable
        public DBSDataContainer extractContainer() {
            if (this.dataSourceContainer == null) {
                return null;
            }
            DataSourceContextProvider contextProvider = new DataSourceContextProvider((DBSObject)this.dataSourceContainer);
            DBCExecutionContext executionContext = contextProvider.getExecutionContext();
            if (executionContext == null) {
                return null;
            }
            IDocument document = this.editor.getDocument();
            if (document == null) {
                return null;
            }
            return new SQLQueryDataContainer((DBPContextProvider)contextProvider, new SQLQuery(executionContext.getDataSource(), document.get()), new SQLScriptContext(null, (DBPContextProvider)contextProvider, null, (Writer)new PrintWriter(System.err, true), null), null);
        }

        @Override
        @Nullable
        public String getError() {
            if (this.dataSourceContainer == null) {
                return DCMessages.data_compare_wizard_objects_error_no_data_source_selected;
            }
            IDocument document = this.editor.getDocument();
            if (document == null || document.get().isEmpty()) {
                return DCMessages.data_compare_wizard_objects_error_empty_query;
            }
            return null;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.changeNotifier.run();
        }

        private void setContainer(@Nullable DBPDataSourceContainer container) {
            this.dataSourceContainer = container;
            this.containerName.setText(container != null ? this.dataSourceContainer.getName() : "N/A");
            this.containerIcon.setImage(container != null ? DBeaverIcons.getImage((DBPImage)this.dataSourceContainer.getDriver().getIcon()) : null);
        }

        private void setQuery(@NotNull String query) {
            this.editor.setInput((IEditorInput)new StringEditorInput("Query", (CharSequence)query, false, GeneralUtils.getDefaultFileEncoding()));
            this.editor.getDocument().addDocumentListener((IDocumentListener)this);
            this.editor.reloadSyntaxRules();
        }

        @Nullable
        private DBPDataSourceContainer chooseDataSource() {
            DBPProject project = NavigatorUtils.getSelectedProject();
            DBNProject root = project.getNavigatorModel().getRoot().getProjectNode(project);
            DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)this.editor.getEditorControlWrapper().getShell(), DCMessages.data_compare_wizard_objects_choose_data_source_title, (DBNNode)root.getDatabases(), null, new Class[]{DBPDataSourceContainer.class}, new Class[]{DBPDataSourceContainer.class}, new Class[]{DBPDataSourceContainer.class});
            if (node != null) {
                return ((DBNDataSource)node).getDataSourceContainer();
            }
            return null;
        }
    }

    private static class SelectorPanel
    extends Composite {
        private final CTabFolder folder;
        private final CTabItem tableTab;
        private final CTabItem queryTab;

        public SelectorPanel(@NotNull Composite parent, @NotNull String title, @NotNull DBRRunnableContext runnableContext, @NotNull Runnable changeNotifier) {
            super(parent, 0);
            this.setLayoutData(new GridData(1808));
            this.setLayout((Layout)new FillLayout());
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
            this.folder = new CTabFolder((Composite)group, 0x800080);
            this.folder.setLayoutData((Object)new GridData(1808));
            this.folder.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> changeNotifier.run()));
            TableDataSourcePanel tablePanel = new TableDataSourcePanel(runnableContext);
            this.tableTab = new CTabItem(this.folder, 0);
            this.tableTab.setText(DCMessages.data_compare_wizard_objects_table_title);
            this.tableTab.setData((Object)tablePanel);
            this.tableTab.setControl(tablePanel.createControl((Composite)this.folder, changeNotifier));
            QueryDataSourcePanel queryPanel = new QueryDataSourcePanel();
            this.queryTab = new CTabItem(this.folder, 0);
            this.queryTab.setText(DCMessages.data_compare_wizard_objects_query_title);
            this.queryTab.setData((Object)queryPanel);
            this.queryTab.setControl(queryPanel.createControl((Composite)this.folder, changeNotifier));
            this.folder.setSelection(this.tableTab);
        }

        public void init(@NotNull DBSDataContainer dataContainer) {
            if (dataContainer instanceof SQLQueryContainer) {
                this.folder.setSelection(this.queryTab);
            } else {
                this.folder.setSelection(this.tableTab);
            }
            this.getActivePanel().loadContainer(dataContainer);
        }

        @NotNull
        private DataSourcePanel getActivePanel() {
            return (DataSourcePanel)this.folder.getSelection().getData();
        }
    }

    private static class TableDataSourcePanel
    implements DataSourcePanel {
        private final DBRRunnableContext runnableContext;
        private DatabaseObjectsSelectorPanel panel;
        private DBSDataContainer dataContainer;

        public TableDataSourcePanel(@NotNull DBRRunnableContext runnableContext) {
            this.runnableContext = runnableContext;
        }

        @Override
        @NotNull
        public Control createControl(@NotNull Composite parent, @NotNull Runnable changeNotifier) {
            this.panel = new DatabaseObjectsSelectorPanel(parent, this.runnableContext, 4);
            this.panel.addSelectionListener(event -> {
                DBSDataContainer container;
                DBNDatabaseItem item;
                DBSObject dBSObject;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object object = selection.getFirstElement();
                this.dataContainer = object instanceof DBNDatabaseItem && (dBSObject = (item = (DBNDatabaseItem)object).getObject()) instanceof DBSDataContainer ? (container = (DBSDataContainer)dBSObject) : null;
                changeNotifier.run();
            });
            return this.panel;
        }

        @Override
        public void loadContainer(@NotNull DBSDataContainer container) {
            try {
                ArrayList selection = new ArrayList(1);
                this.runnableContext.run(true, true, monitor -> {
                    DBNDatabaseNode node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)container, (boolean)false);
                    if (node != null) {
                        selection.add(node);
                    } else {
                        log.warn((Object)("Cannot find node for container '" + DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'"));
                    }
                });
                this.panel.refreshNodes();
                this.panel.checkNodes(selection, true);
                this.panel.setSelection(selection);
                this.dataContainer = container;
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Data Compare", "Error updating settings", e.getTargetException());
            }
            catch (InterruptedException e) {
                log.debug((Object)"Canceled by user", (Throwable)e);
            }
        }

        @Override
        @Nullable
        public DBSDataContainer extractContainer() {
            return this.dataContainer;
        }

        @Override
        @Nullable
        public String getError() {
            if (this.dataContainer == null) {
                return DCMessages.data_compare_wizard_objects_error_no_table_selected;
            }
            return null;
        }
    }
}

