/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.handlers;

import com.dbeaver.data.compare.model.DCUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DCCompareEntitiesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        SQLEditor editor;
        ArrayList<DBSDataContainer> input = new ArrayList<DBSDataContainer>();
        for (Object object : HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event)) {
            DBSObject dBSObject = DBUtils.getFromObject(object);
            if (dBSObject instanceof DBSDataContainer) {
                DBSDataContainer container = (DBSDataContainer)dBSObject;
                input.add(container);
            }
            if (input.size() > 1) break;
        }
        if (input.isEmpty() && (editor = (SQLEditor)GeneralUtils.adapt((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class)) != null && editor.getDataSource() != null) {
            DBPDataSource dataSource = editor.getDataSource();
            List queries = editor.getSelectedQueries();
            int i = 0;
            while (i < Math.min(queries.size(), 2)) {
                input.add(DCUtils.createDataContainerFromQuery((DBPDataSource)dataSource, (String)((SQLScriptElement)queries.get(i)).getText()));
                ++i;
            }
        }
        TaskConfigurationWizardDialog.openNewTaskDialog((IWorkbenchWindow)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), (DBPProject)NavigatorUtils.getSelectedProject(), (String)"dataCompare", (IStructuredSelection)new StructuredSelection(input.toArray()));
        return null;
    }
}

