/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.websocket.registry.WSClientEventDescriptor;
import org.jkiss.dbeaver.model.websocket.registry.WSServerEventDescriptor;

public class WSEventRegistry {
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.ws.event";
    private static final String EVENT_TAG = "event";
    private static final String CLIENT_EVENT_TAG = "clientEvent";
    private static WSEventRegistry instance = null;
    private final List<WSServerEventDescriptor> serverEvents = new ArrayList<WSServerEventDescriptor>();
    private final List<WSClientEventDescriptor> clientEvents = new ArrayList<WSClientEventDescriptor>();

    private WSEventRegistry() {
    }

    public static synchronized WSEventRegistry getInstance() {
        if (instance == null) {
            instance = new WSEventRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private void loadExtensions(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (EVENT_TAG.equals(ext.getName())) {
                descriptor = new WSServerEventDescriptor(ext);
                this.serverEvents.add((WSServerEventDescriptor)descriptor);
            } else if (CLIENT_EVENT_TAG.equals(ext.getName())) {
                descriptor = new WSClientEventDescriptor(ext);
                this.clientEvents.add((WSClientEventDescriptor)descriptor);
            }
            ++n2;
        }
    }

    @NotNull
    public List<WSServerEventDescriptor> getServerEvents() {
        return new ArrayList<WSServerEventDescriptor>(this.serverEvents);
    }

    @NotNull
    public List<WSClientEventDescriptor> getClientEvents() {
        return new ArrayList<WSClientEventDescriptor>(this.clientEvents);
    }
}

