/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.registry.WSEventHandlerDescriptor;

public class WSEventHandlersRegistry {
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.ws.event.handler";
    private static final String EVENT_HANDLER_TAG = "eventHandler";
    private static WSEventHandlersRegistry instance = null;

    public static synchronized WSEventHandlersRegistry getInstance() {
        if (instance == null) {
            instance = new WSEventHandlersRegistry();
        }
        return instance;
    }

    @NotNull
    public List<WSEventHandler> getEventHandlers() {
        List<WSEventHandlerDescriptor> eventHandlerDescriptors = this.readDescriptors();
        return eventHandlerDescriptors.stream().map(WSEventHandlerDescriptor::getInstance).collect(Collectors.toList());
    }

    @NotNull
    public List<WSEventHandlerDescriptor> readDescriptors() {
        ArrayList<WSEventHandlerDescriptor> result = new ArrayList<WSEventHandlerDescriptor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (EVENT_HANDLER_TAG.equals(ext.getName())) {
                result.add(new WSEventHandlerDescriptor(ext));
            }
            ++n2;
        }
        return result;
    }
}

