/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.event.resource;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.websocket.event.WSProjectResourceEvent;
import org.jkiss.dbeaver.model.websocket.event.resource.WSResourceProperty;

public class WSResourceUpdatedEvent
extends WSProjectResourceEvent {
    public static final String CREATED = "cb_rm_resource_created";
    public static final String UPDATED = "cb_rm_resource_updated";
    public static final String DELETED = "cb_rm_resource_deleted";
    @NotNull
    private final String resourcePath;
    @NotNull
    private final WSResourceProperty property;
    @Nullable
    private final String details;

    private WSResourceUpdatedEvent(@NotNull String eventId, @Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull String resourcePath, @NotNull WSResourceProperty property, @Nullable String details) {
        super(eventId, "cb_scripts", sessionId, userId, projectId);
        this.property = property;
        this.resourcePath = resourcePath;
        this.details = details;
    }

    public static WSResourceUpdatedEvent create(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull String resourcePath, @NotNull WSResourceProperty property, @Nullable String details) {
        return new WSResourceUpdatedEvent(CREATED, sessionId, userId, projectId, resourcePath, property, details);
    }

    public static WSResourceUpdatedEvent update(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull String resourcePath, @NotNull WSResourceProperty property, @Nullable String details) {
        return new WSResourceUpdatedEvent(UPDATED, sessionId, userId, projectId, resourcePath, property, details);
    }

    public static WSResourceUpdatedEvent delete(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull String resourcePath, @NotNull WSResourceProperty property, @Nullable String details) {
        return new WSResourceUpdatedEvent(DELETED, sessionId, userId, projectId, resourcePath, property, details);
    }

    @Override
    @NotNull
    public String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public String getResourcePath() {
        return this.resourcePath;
    }

    @NotNull
    public WSResourceProperty getProperty() {
        return this.property;
    }

    @Nullable
    public String getDetails() {
        return this.details;
    }
}

