/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.event.datasource;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.websocket.event.WSProjectResourceEvent;
import org.jkiss.dbeaver.model.websocket.event.datasource.WSDataSourceProperty;

public class WSDataSourceEvent
extends WSProjectResourceEvent {
    public static final String CREATED = "cb_datasource_created";
    public static final String DELETED = "cb_datasource_deleted";
    public static final String UPDATED = "cb_datasource_updated";
    @NotNull
    private final List<String> dataSourceIds;
    @NotNull
    private final WSDataSourceProperty property;

    private WSDataSourceEvent(@NotNull String eventId, @Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull List<String> dataSourceIds, @NotNull WSDataSourceProperty property) {
        super(eventId, "cb_datasource", sessionId, userId, projectId);
        this.dataSourceIds = dataSourceIds;
        this.property = property;
    }

    public static WSDataSourceEvent create(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull List<String> datasourceIds, @NotNull WSDataSourceProperty property) {
        return new WSDataSourceEvent(CREATED, sessionId, userId, projectId, datasourceIds, property);
    }

    public static WSDataSourceEvent delete(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull List<String> datasourceIds, @NotNull WSDataSourceProperty property) {
        return new WSDataSourceEvent(DELETED, sessionId, userId, projectId, datasourceIds, property);
    }

    public static WSDataSourceEvent update(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull List<String> datasourceIds, @NotNull WSDataSourceProperty property) {
        return new WSDataSourceEvent(UPDATED, sessionId, userId, projectId, datasourceIds, property);
    }

    @NotNull
    public List<String> getDataSourceIds() {
        return this.dataSourceIds;
    }

    @NotNull
    public WSDataSourceProperty getProperty() {
        return this.property;
    }
}

