/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.event;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.rm.RMProjectInfo;
import org.jkiss.dbeaver.model.websocket.event.WSAbstractEvent;
import org.jkiss.dbeaver.model.websocket.event.WSProjectEvent;

public class WSProjectUpdateEvent
extends WSAbstractEvent
implements WSProjectEvent {
    public static final String ADDED = "cb_rm_project_added";
    public static final String UPDATED = "cb_rm_project_updated";
    public static final String REMOVED = "cb_rm_project_removed";
    @NotNull
    protected final String projectId;
    @Nullable
    protected final RMProjectInfo projectInfo;

    public WSProjectUpdateEvent(@NotNull String eventId, @Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @Nullable RMProjectInfo projectInfo) {
        super(eventId, "cb_projects", sessionId, userId);
        this.projectId = projectId;
        this.projectInfo = projectInfo;
    }

    public static WSProjectUpdateEvent create(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId) {
        return new WSProjectUpdateEvent(ADDED, sessionId, userId, projectId, null);
    }

    public static WSProjectUpdateEvent update(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId, @NotNull RMProjectInfo projectInfo) {
        return new WSProjectUpdateEvent(UPDATED, sessionId, userId, projectId, projectInfo);
    }

    public static WSProjectUpdateEvent delete(@Nullable String sessionId, @Nullable String userId, @NotNull String projectId) {
        return new WSProjectUpdateEvent(REMOVED, sessionId, userId, projectId, null);
    }

    @Override
    @NotNull
    public String getProjectId() {
        return this.projectId;
    }

    @Nullable
    public RMProjectInfo getProjectInfo() {
        return this.projectInfo;
    }
}

