/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.websocket.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.websocket.WSEventHandler;
import org.jkiss.dbeaver.model.websocket.event.WSEvent;
import org.jkiss.dbeaver.model.websocket.registry.WSEventHandlerDescriptor;
import org.jkiss.dbeaver.model.websocket.registry.WSEventHandlersRegistry;

public class WSEventController {
    private static final Log log = Log.getLog(WSEventController.class);
    public static final Object JOB_EVENT_HANDLER_FAMILY = new Object();
    private final Map<String, List<WSEventHandler>> eventHandlersByType = new HashMap<String, List<WSEventHandler>>();
    protected final List<WSEvent> eventsPool = new ArrayList<WSEvent>();
    private boolean forceSkipEvents = false;

    public WSEventController() {
        List<WSEventHandlerDescriptor> eventHandlerDescriptors = WSEventHandlersRegistry.getInstance().readDescriptors();
        eventHandlerDescriptors.forEach(descriptor -> {
            WSEventHandler handler = descriptor.getInstance();
            descriptor.getSupportedTopics().forEach(topic -> {
                boolean bl = this.eventHandlersByType.computeIfAbsent((String)topic, x -> new ArrayList()).add(handler);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(@NotNull WSEvent event) {
        if (!event.isForceProcessed() && this.forceSkipEvents) {
            return;
        }
        List<WSEvent> list = this.eventsPool;
        synchronized (list) {
            this.eventsPool.add(event);
        }
    }

    public void scheduleCheckJob() {
        new CBEventCheckJob().schedule();
    }

    public void setForceSkipEvents(boolean forceSkipEvents) {
        this.forceSkipEvents = forceSkipEvents;
    }

    private class CBEventCheckJob
    extends AbstractJob {
        private static final long CHECK_PERIOD = 1000L;

        protected CBEventCheckJob() {
            super("CloudBeaver events job");
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            List<WSEvent> events;
            List<WSEvent> list = WSEventController.this.eventsPool;
            synchronized (list) {
                events = List.copyOf(WSEventController.this.eventsPool);
                WSEventController.this.eventsPool.clear();
            }
            if (monitor.isCanceled() || Thread.currentThread().isInterrupted()) {
                return Status.CANCEL_STATUS;
            }
            for (WSEvent event : events) {
                WSEventController.this.eventHandlersByType.getOrDefault(event.getTopicId(), List.of()).forEach(handler -> {
                    try {
                        handler.handleEvent(event);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error on event handle " + event.getTopicId()), (Throwable)e);
                    }
                });
            }
            if (monitor.isCanceled() || Thread.currentThread().isInterrupted()) {
                return Status.CANCEL_STATUS;
            }
            this.schedule(1000L);
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return JOB_EVENT_HANDLER_FAMILY.equals(family);
        }
    }
}

