/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.DCChangeType;
import java.util.Arrays;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class DCChangeSetMemory
implements DCChangeSet {
    private final DCChangeType state;
    private final DBDAttributeValue[] keys;
    private final DBDAttributeValue[] sourceValues;
    private final DBDAttributeValue[] targetValues;

    public DCChangeSetMemory(@NotNull DCChangeType state, @NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] sourceValues, @NotNull DBDAttributeValue[] targetValues) {
        this.state = state;
        this.keys = keys;
        this.sourceValues = sourceValues;
        this.targetValues = targetValues;
    }

    public DCChangeSetMemory(@NotNull DCChangeType state, @NotNull DBDAttributeValue[] keys, @NotNull DBDAttributeValue[] values) {
        this(state, keys, values, values);
    }

    @Override
    @NotNull
    public DCChangeType getChangeType() {
        return this.state;
    }

    @Override
    @NotNull
    public DBDAttributeValue[] getKeys() {
        return this.keys;
    }

    @Override
    @NotNull
    public DBDAttributeValue[] getSourceValues() {
        return this.sourceValues;
    }

    @Override
    @NotNull
    public DBDAttributeValue[] getTargetValues() {
        return this.targetValues;
    }

    @Override
    @NotNull
    public DBDAttributeValue[] getValues(@NotNull DCChangeRelation relation) {
        return relation.isSource() ? this.sourceValues : this.targetValues;
    }

    @Override
    @NotNull
    public DBDAttributeValue getValue(@NotNull DBSAttributeBase attr, @NotNull DCChangeRelation relation) {
        DBDAttributeValue value = this.findValue(attr, relation);
        if (value == null) {
            throw new IllegalArgumentException("Attribute '" + attr.getName() + "' not found in " + String.valueOf((Object)relation) + " values");
        }
        return value;
    }

    @Override
    public boolean hasValue(@NotNull DBSAttributeBase attr, @NotNull DCChangeRelation relation) {
        return this.findValue(attr, relation) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DCChangeSetMemory diff = (DCChangeSetMemory)o;
        return this.state == diff.state && Arrays.equals(this.keys, diff.keys) && Arrays.equals(this.sourceValues, diff.sourceValues) && Arrays.equals(this.targetValues, diff.targetValues);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.state});
        result = 31 * result + Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.sourceValues);
        result = 31 * result + Arrays.hashCode(this.targetValues);
        return result;
    }

    @Nullable
    private DBDAttributeValue findValue(@NotNull DBSAttributeBase attr, @NotNull DCChangeRelation relation) {
        DBDAttributeValue[] dBDAttributeValueArray = this.getValues(relation);
        int n = dBDAttributeValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeValue value = dBDAttributeValueArray[n2];
            if (value.getAttribute() == attr) {
                return value;
            }
            ++n2;
        }
        return null;
    }
}

