/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model;

import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCInput;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class DCSettings {
    private final DCInput leftInput;
    private final DCInput rightInput;
    private final Map<DBSAttributeBase, DBSAttributeBase> mappings;
    private long comparedRowsLimit;
    private long differentRowsLimit;
    private int fetchSize;
    private boolean includeModifiedRows;
    private boolean includeDeletedRows;
    private boolean includeInsertedRows;
    private boolean storeResultsInMemory;
    private boolean openNewConnections;
    private boolean queryRowsCount;
    private PrintStream outputLogStream;

    public DCSettings(@NotNull DCInput leftInput, @NotNull DCInput rightInput, @NotNull Map<DBSAttributeBase, DBSAttributeBase> mappings) {
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.mappings = mappings;
    }

    @NotNull
    public DCInput getInput(@NotNull DCChangeRelation relation) {
        return relation.isSource() ? this.leftInput : this.rightInput;
    }

    @NotNull
    public DCInput getLeftInput() {
        return this.leftInput;
    }

    @NotNull
    public DCInput getRightInput() {
        return this.rightInput;
    }

    @NotNull
    public Map<DBSAttributeBase, DBSAttributeBase> getMappings() {
        return this.mappings;
    }

    @NotNull
    public Collection<DBSAttributeBase> getMappings(@NotNull DCChangeRelation relation) {
        return relation.isSource() ? this.mappings.keySet() : this.mappings.values();
    }

    public long getComparedRowsLimit() {
        return this.comparedRowsLimit;
    }

    public void setComparedRowsLimit(long comparedRowsLimit) {
        this.comparedRowsLimit = comparedRowsLimit;
    }

    public long getDifferentRowsLimit() {
        return this.differentRowsLimit;
    }

    public void setDifferentRowsLimit(long differentRowsLimit) {
        this.differentRowsLimit = differentRowsLimit;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchLimit) {
        this.fetchSize = fetchLimit;
    }

    public boolean isIncludeModifiedRows() {
        return this.includeModifiedRows;
    }

    public void setIncludeModifiedRows(boolean includeModifiedRows) {
        this.includeModifiedRows = includeModifiedRows;
    }

    public boolean isIncludeDeletedRows() {
        return this.includeDeletedRows;
    }

    public void setIncludeDeletedRows(boolean includeDeletedRows) {
        this.includeDeletedRows = includeDeletedRows;
    }

    public boolean isIncludeInsertedRows() {
        return this.includeInsertedRows;
    }

    public void setIncludeInsertedRows(boolean includeInsertedRows) {
        this.includeInsertedRows = includeInsertedRows;
    }

    public boolean isStoreResultsInMemory() {
        return this.storeResultsInMemory;
    }

    public void setStoreResultsInMemory(boolean storeResultsInMemory) {
        this.storeResultsInMemory = storeResultsInMemory;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    public boolean isQueryRowsCount() {
        return this.queryRowsCount;
    }

    public void setQueryRowsCount(boolean queryRowsCount) {
        this.queryRowsCount = queryRowsCount;
    }

    @Nullable
    public PrintStream getOutputLogStream() {
        return this.outputLogStream;
    }

    public void setOutputLogStream(@Nullable PrintStream outputLogStream) {
        this.outputLogStream = outputLogStream;
    }
}

