/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.license.embedded;

import com.dbeaver.lm.api.LMEnvironment;
import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMKeyProvider;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMLicenseStatus;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMLicenseValidator;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.lm.api.LMReleaseInfo;
import com.dbeaver.lm.api.LMSubscription;
import com.dbeaver.lm.api.LMUpdateGroupUsersRequest;
import com.dbeaver.lm.api.LMUtils;
import com.dbeaver.lm.api.LMValidateException;
import com.dbeaver.model.license.DBPLicenseService;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.model.license.embedded.LicenseKeyProviderEmbedded;
import com.dbeaver.model.license.validate.LMPublicAPI;
import com.dbeaver.model.license.validate.LicenseRequest;
import com.dbeaver.model.license.validate.PublicLicenseValidator;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class LicenseServiceEmbedded
implements DBPLicenseService {
    private static final Log log = Log.getLog(LicenseServiceEmbedded.class);
    public static final String LICENSE_FILE_NAME = ".lm";
    private static final String ENV_VAR_LICENSE_CUSTOM_PATH = "DBEAVER_LICENSE_CUSTOM_PATH";
    private final LMLicenseManager licenseManager;
    private static final LMEnvironment lmEnvironment = new LMEnvironment();

    static {
        IProduct product = Platform.getProduct();
        if (product != null) {
            lmEnvironment.setProductPurchaseURL(Platform.getProduct().getProperty("productPurchaseURL"));
            lmEnvironment.setArchiveURL(Platform.getProduct().getProperty("archiveURL"));
        }
    }

    public LicenseServiceEmbedded() {
        this(false);
    }

    public LicenseServiceEmbedded(boolean workspaceStorage) {
        this(workspaceStorage, PublicLicenseValidator.PUBLIC_LICENSE_VALIDATOR);
    }

    public LicenseServiceEmbedded(boolean workspaceStorage, LMLicenseValidator validator) {
        log.debug((Object)("\tInitialize license manager for " + LMAppUtils.getActiveProduct().getId()));
        this.licenseManager = new LMLicenseManager(lmEnvironment, (LMKeyProvider)new LicenseKeyProviderEmbedded(), validator, LicenseServiceEmbedded.getLicenceRootFolder());
        this.setLicenseCustomPath();
        if (workspaceStorage) {
            this.licenseManager.setConfigPath(DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(LICENSE_FILE_NAME));
        }
    }

    @Override
    @Nullable
    public LMLicense getActiveProductLicense(boolean validate) throws LMException {
        return this.licenseManager.getValidProductLicense(validate ? this.getClientId() : null, LMAppUtils.getActiveProduct());
    }

    @Override
    @NotNull
    public LMLicense[] getAllProductLicenses() {
        return this.licenseManager.getProductLicenses(DBPApplicationLicensed.getLicensedApplication().getLicenseProduct());
    }

    @Override
    public LMLicense importProductLicense(@NotNull String licenseText) throws LMException {
        try {
            byte[] licenseData = LMUtils.readEncryptedString((Reader)new StringReader(licenseText.trim()));
            return this.licenseManager.importLicense(DBPApplicationLicensed.getLicensedApplication().getLicenseProduct(), this.getClientId(), licenseData);
        }
        catch (Exception e) {
            throw new LMException("Error importing license", (Throwable)e);
        }
    }

    @Override
    public boolean invalidateActiveLicense(boolean forceRefresh) throws LMException {
        if (forceRefresh) {
            this.licenseManager.clearLicenseCache();
        }
        try {
            LMLicense license = this.licenseManager.getValidProductLicense(this.getClientId(), LMAppUtils.getActiveProduct());
            if (license == null) {
                log.error((Object)("No license found for " + LMAppUtils.getActiveProduct().getName()));
                return false;
            }
            return true;
        }
        catch (LMValidateException lmException) {
            log.error((Object)lmException.getMessage(), (Throwable)lmException);
            return lmException.getStatus() == LMLicenseStatus.VALID;
        }
        catch (Exception e) {
            throw new LMException("Error reading valid license info", (Throwable)e);
        }
    }

    @NotNull
    private String getClientId() {
        return DBWorkbench.getPlatform().getWorkspace().getWorkspaceId();
    }

    @Override
    public void validateLicense(@NotNull LMLicense license) throws LMValidateException {
        this.licenseManager.validateLicense(this.getClientId(), LMAppUtils.getActiveProduct(), license);
    }

    @Override
    public String getLicenseStatus(@NotNull LMLicense license) throws LMException {
        return this.licenseManager.getLicenseValidationStatus(LMAppUtils.getActiveProduct(), license);
    }

    @Override
    public LMProduct getActiveProduct() {
        return DBPApplicationLicensed.getLicensedApplication().getLicenseProduct();
    }

    @Override
    public LMSubscription getSubscriptionInfo(@NotNull LMLicense license) throws LMException {
        return this.licenseManager.getSubscriptionInfo(license);
    }

    @Override
    @Nullable
    public LMReleaseInfo getReleaseInfo(@NotNull LMLicense license) {
        return this.licenseManager.getReleaseInfo(license);
    }

    @Override
    public void deleteLicense(@NotNull LMLicense license) throws LMException {
        if (license.getLicenseType() == LMLicenseType.TRIAL) {
            throw new LMException("You can't delete trial license.");
        }
        this.licenseManager.deleteLicense(LMAppUtils.getActiveProduct(), license);
    }

    @Override
    public void deleteLicense(@NotNull String licenseId) throws LMException {
        LMLicense lmLicense = Arrays.stream(this.getAllProductLicenses()).filter(l -> licenseId.equals(l.getLicenseId())).findFirst().orElseThrow(() -> new LMException("Cannot find any license with id '" + licenseId + "'"));
        this.deleteLicense(lmLicense);
    }

    @Override
    public LMLicense refreshProductLicense(@NotNull LMLicense license) throws LMException {
        this.licenseManager.clearLicenseCache(license);
        this.licenseManager.validateLicense(this.getClientId(), LMAppUtils.getActiveProduct(), license);
        license = this.licenseManager.findImportedLicenseById(LMAppUtils.getActiveProduct(), license.getLicenseId());
        return license;
    }

    @Override
    public String getActiveEncodedLicense() throws LMException {
        LMLicense license = this.getActiveProductLicense(false);
        if (license == null) {
            throw new LMException("No active license found");
        }
        return Base64.getEncoder().encodeToString(license.getEncoded());
    }

    public LMLicense findTrialLicense() throws LMException {
        return this.licenseManager.findTrialLicense(this.getClientId(), LMAppUtils.getActiveProduct());
    }

    public IStatus requestTrialLicense(@NotNull DBRProgressMonitor monitor, @NotNull LicenseRequest request) {
        return LMPublicAPI.requestTrialLicense(monitor, this.getClientId(), LMAppUtils.getActiveProduct(), request);
    }

    @NotNull
    public LMLicense joinEarlyAccessProgram(@NotNull DBRProgressMonitor monitor, @NotNull LMLicense license) throws LMException {
        LMProduct product = LMAppUtils.getActiveProduct();
        LMLicense newLicense = LMPublicAPI.joinEarlyAccessProgram(monitor, this.getClientId(), product, license, this.licenseManager);
        this.licenseManager.importLicense(product, newLicense, true);
        return newLicense;
    }

    @NotNull
    private static Path getLicenceRootFolder() {
        String workingDirectory = RuntimeUtils.getWorkingDirectory((String)".jkiss-lm");
        Path directory = Path.of(workingDirectory, new String[0]);
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (Exception exception) {
                Path legacyDir = Path.of(System.getProperty("user.home"), ".jkiss-lm");
                log.warn((Object)("Can't create License folder in " + String.valueOf(directory.toAbsolutePath()) + "\n Using backup destination: " + String.valueOf(legacyDir.toAbsolutePath())));
                if (!Files.exists(legacyDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(legacyDir, new FileAttribute[0]);
                    }
                    catch (Exception eLegacy) {
                        log.error((Object)("Can't create LM config directory: " + eLegacy.getMessage()));
                    }
                }
                return legacyDir;
            }
        }
        return directory;
    }

    public String updateUserList(@NotNull DBRProgressMonitor monitor, @NotNull LMLicense license, @NotNull LMUpdateGroupUsersRequest licenseChanges) throws LMException {
        return LMPublicAPI.updateUserList(monitor, this.getClientId(), license, licenseChanges);
    }

    @NotNull
    public LMLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    private void setLicenseCustomPath() {
        IProduct product;
        String envLicensePath = System.getenv(ENV_VAR_LICENSE_CUSTOM_PATH);
        if (CommonUtils.isNotEmpty((String)envLicensePath)) {
            try {
                Path envPath = Path.of(envLicensePath, new String[0]);
                if (Files.exists(envPath, new LinkOption[0])) {
                    LMLicenseManager.setLicenseCustomPath((String)envLicensePath);
                    return;
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Error opening custom license path from environment variable DBEAVER_LICENSE_CUSTOM_PATH", e);
            }
        }
        if ((product = Platform.getProduct()) == null) {
            return;
        }
        String pathToLicenseFile = product.getProperty("productLicense");
        if (!CommonUtils.isEmpty((String)pathToLicenseFile)) {
            try {
                URL url = FileLocator.toFileURL((URL)new URL(pathToLicenseFile));
                File localFile = new File(url.getFile());
                LMLicenseManager.setLicenseCustomPath((String)localFile.getAbsolutePath());
            }
            catch (Throwable e) {
                log.warn((Object)"Error opening product license", e);
            }
        }
    }
}

