/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakePrimaryKey;
import com.dbeaver.db.snowflake.model.SnowflakeSchema;
import com.dbeaver.db.snowflake.model.SnowflakeTableStatistics;
import com.dbeaver.db.snowflake.model.SnowflakeUniqueKey;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SnowflakeTable
extends GenericTable
implements DBPObjectStatistics,
DBSEntityConstrainable {
    private final SnowflakeTableStatistics tableStatistics;
    private long tableSize = -1L;
    private String clusteringKey;

    public SnowflakeTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        this.tableStatistics = new SnowflakeTableStatistics(dbResult);
        if (dbResult != null) {
            this.tableSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BYTES");
            this.clusteringKey = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLUSTERING_KEY");
        }
    }

    @Property(viewable=true, order=6)
    @Nullable
    public Date getCreateTime() {
        return this.tableStatistics.getCreateTime();
    }

    @Property(viewable=true, order=7)
    @Nullable
    public Date getLastAlter() {
        return this.tableStatistics.getLastAlter();
    }

    @Property(viewable=true, order=8)
    public String getClusteringKey() {
        return this.clusteringKey;
    }

    @NotNull
    public List<DBSEntityConstraintInfo> getSupportedConstraints() {
        return List.of(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.PRIMARY_KEY, SnowflakePrimaryKey.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.UNIQUE_KEY, SnowflakeUniqueKey.class));
    }

    @Association
    public Collection<SnowflakeUniqueKey> getUniqueKeys(DBRProgressMonitor monitor) throws DBException {
        return ((SnowflakeSchema)this.getSchema()).getUniqueConstraintCache().getTypedObjects(monitor, (DBSObject)this.getSchema(), (DBSObject)this, SnowflakeUniqueKey.class);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((SnowflakeSchema)this.getSchema()).getUniqueConstraintCache().clearObjectCache((DBSObject)this);
        return super.refreshObject(monitor);
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }
}

