/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.edit;

import com.dbeaver.db.snowflake.model.SnowflakeSchema;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSchemaManager
extends SQLObjectEditor<SnowflakeSchema, GenericCatalog> {
    public boolean canCreateObject(@NotNull Object container) {
        return true;
    }

    public boolean canDeleteObject(@NotNull SnowflakeSchema object) {
        return true;
    }

    protected String getBaseObjectName() {
        return "NEW_SCHEMA";
    }

    protected SnowflakeSchema createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        if (container instanceof GenericCatalog) {
            GenericCatalog catalog = (GenericCatalog)container;
            SnowflakeSchema schema = new SnowflakeSchema(catalog.getDataSource(), catalog, "NEW_SCHEMA", null);
            this.setNewObjectName(monitor, (DBSObject)catalog, (DBSObject)schema);
            return schema;
        }
        return null;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", "CREATE SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)command.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        SnowflakeSchema schema = (SnowflakeSchema)command.getObject();
        if (command.getProperties().containsKey("retentionTime")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter schema retention time", "ALTER SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)schema, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " SET DATA_RETENTION_TIME_IN_DAYS = " + schema.getRetentionTime()));
        }
        if (command.getProperties().containsKey("managedAccess")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter schema access", "ALTER SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)schema, (DBPEvaluationContext)DBPEvaluationContext.DDL) + (schema.isManagedAccess() ? " ENABLE" : " DISABLE") + " MANAGED ACCESS"));
        }
        if (command.getProperties().containsKey("description")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter schema description", "COMMENT ON SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)schema, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)schema, (String)CommonUtils.notEmpty((String)schema.getDescription()))));
        }
        super.addObjectModifyActions(monitor, executionContext, actionList, command, options);
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)command.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL)));
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, SnowflakeSchema> getObjectsCache(SnowflakeSchema object) {
        return null;
    }
}

