/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.ui.views;

import com.dbeaver.db.google.bigtable.ui.BigTableDBMessages;
import com.dbeaver.db.google.bigtable.ui.BigTableUIActivator;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class BigTableConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private static ImageDescriptor logoImage = BigTableUIActivator.getImageDescriptor("icons/bigtable_logo.png");
    private boolean activated;
    private Combo projectText;
    private Combo instanceCombo;

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        this.createSettingsGroup(group);
        this.createAuthPanel(group, 1);
        this.createDriverPanel(group);
        this.setControl((Control)group);
    }

    private Composite createSettingsGroup(Composite parent) {
        ModifyListener textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        Group settingsGroup = UIUtils.createControlGroup((Composite)parent, (String)BigTableDBMessages.connection_page_control_group_settings, (int)2, (int)768, (int)0);
        this.projectText = UIUtils.createLabelCombo((Composite)settingsGroup, (String)BigTableDBMessages.connection_page_control_project_label, (int)4);
        GridData gd = new GridData(32);
        gd.widthHint = 300;
        this.projectText.setLayoutData((Object)gd);
        this.projectText.addModifyListener(textListener);
        this.createDatabaseGroup((Composite)settingsGroup);
        return settingsGroup;
    }

    private void createDatabaseGroup(Composite composite) {
        this.instanceCombo = UIUtils.createLabelCombo((Composite)composite, (String)BigTableDBMessages.connection_page_label_instance, (String)BigTableDBMessages.connection_page_tip_instance, (int)4);
        GridData gd = new GridData(32);
        gd.widthHint = 300;
        this.instanceCombo.setLayoutData((Object)gd);
    }

    public boolean isComplete() {
        return !CommonUtils.isEmpty((String)this.projectText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.instanceCombo != null) {
            this.instanceCombo.setText(CommonUtils.toString((Object)connectionInfo.getServerName()));
        }
        this.projectText.setText(CommonUtils.toString((Object)connectionInfo.getProviderProperty("projectId")));
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.instanceCombo != null) {
            connectionInfo.setServerName(this.instanceCombo.getText());
        }
        if (this.projectText != null) {
            connectionInfo.setProviderProperty("projectId", this.projectText.getText().trim());
        }
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    @Nullable
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

