/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;

public final class VertxUtils {
    private VertxUtils() {
    }

    public static void checkIsWorker() {
        if (!Context.isOnWorkerThread()) {
            throw new IllegalStateException("Not a worker thread");
        }
    }

    public static void checkContext(Context context) {
        if (!VertxUtils.isEventLoopAndSameContext(context)) {
            throw new IllegalStateException("On wrong context or worker");
        }
    }

    public static boolean isEventLoopAndSameContext(Context context) {
        return Context.isOnEventLoopThread() && (context == Vertx.currentContext() || VertxUtils.checkDuplicateContext(Vertx.currentContext(), context) || VertxUtils.checkDuplicateContext(context, Vertx.currentContext()));
    }

    private static boolean checkDuplicateContext(Context context, Context other) {
        return context instanceof ContextInternal && ((ContextInternal)context).isDuplicate() && ((ContextInternal)context).unwrap() == other;
    }
}

