/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.connect;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public final class SchemaWalker {
    private static final Map<Schema.Type, BiFunction<Visitor<?, ?>, Schema, Object>> HANDLER = ImmutableMap.builder().put((Object)Schema.Type.BOOLEAN, Visitor::visitBoolean).put((Object)Schema.Type.INT8, Visitor::visitInt8).put((Object)Schema.Type.INT16, Visitor::visitInt16).put((Object)Schema.Type.INT32, Visitor::visitInt32).put((Object)Schema.Type.INT64, Visitor::visitInt64).put((Object)Schema.Type.FLOAT32, Visitor::visitFloat32).put((Object)Schema.Type.FLOAT64, Visitor::visitFloat64).put((Object)Schema.Type.STRING, Visitor::visitString).put((Object)Schema.Type.BYTES, Visitor::visitBytes).put((Object)Schema.Type.ARRAY, SchemaWalker::visitArray).put((Object)Schema.Type.MAP, SchemaWalker::visitMap).put((Object)Schema.Type.STRUCT, SchemaWalker::visitStruct).build();

    private SchemaWalker() {
    }

    public static <S, F> S visit(Schema schema, Visitor<S, F> visitor) {
        BiFunction<Visitor<?, ?>, Schema, Object> handler = HANDLER.get(schema.type());
        if (handler == null) {
            throw new UnsupportedOperationException("Unsupported schema type: " + schema.type());
        }
        return (S)handler.apply(visitor, schema);
    }

    private static <S, F> S visitArray(Visitor<S, F> visitor, Schema schema) {
        S element = SchemaWalker.visit(schema.valueSchema(), visitor);
        return visitor.visitArray(schema, element);
    }

    private static <S, F> S visitMap(Visitor<S, F> visitor, Schema schema) {
        S key = SchemaWalker.visit(schema.keySchema(), visitor);
        S value = SchemaWalker.visit(schema.valueSchema(), visitor);
        return visitor.visitMap(schema, key, value);
    }

    private static <S, F> S visitStruct(Visitor<S, F> visitor, Schema schema) {
        List fields = schema.fields().stream().map(field -> visitor.visitField((Field)field, SchemaWalker.visit(field.schema(), visitor))).collect(Collectors.toList());
        return visitor.visitStruct(schema, fields);
    }

    public static interface Visitor<S, F> {
        default public S visitSchema(Schema schema) {
            throw new UnsupportedOperationException("Unsupported schema type: " + schema);
        }

        default public S visitPrimitive(Schema schema) {
            return this.visitSchema(schema);
        }

        default public S visitBoolean(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitInt8(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitInt16(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitInt32(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitInt64(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitFloat32(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitFloat64(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitString(Schema schema) {
            return this.visitPrimitive(schema);
        }

        default public S visitBytes(Schema schema) {
            return this.visitSchema(schema);
        }

        default public S visitArray(Schema schema, S element) {
            return this.visitSchema(schema);
        }

        default public S visitMap(Schema schema, S key, S value) {
            return this.visitSchema(schema);
        }

        default public S visitStruct(Schema schema, List<? extends F> fields) {
            return this.visitSchema(schema);
        }

        default public F visitField(Field field, S type) {
            return null;
        }
    }
}

