/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.metrics;

import com.google.common.collect.ImmutableMap;
import io.confluent.common.utils.Time;
import io.confluent.ksql.metrics.MetricCollector;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.metrics.MetricUtils;
import io.confluent.ksql.metrics.TopicSensors;
import io.confluent.ksql.util.KsqlConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;

public class ConsumerCollector
implements MetricCollector,
ConsumerInterceptor<Object, Object> {
    public static final String CONSUMER_MESSAGES_PER_SEC = "consumer-messages-per-sec";
    public static final String CONSUMER_TOTAL_MESSAGES = "consumer-total-messages";
    public static final String CONSUMER_TOTAL_BYTES = "consumer-total-bytes";
    public static final String CONSUMER_ALL_TOTAL_BYTES_SUM = "consumer-all-total-bytes-sum";
    public static final String CONSUMER_COLLECTOR_METRICS_GROUP_NAME = "consumer-metrics";
    private MetricCollectors metricsCollectors;
    private Metrics metrics;
    private Sensor totalBytesSum;
    private final Map<String, TopicSensors<ConsumerRecord<Object, Object>>> topicSensors = new HashMap<String, TopicSensors<ConsumerRecord<Object, Object>>>();
    private String id;
    private String groupId;
    private Time time;

    public void configure(Map<String, ?> map) {
        String id = (String)map.get("group.id");
        if (id != null) {
            this.groupId = id;
        }
        if (id == null) {
            id = (String)map.get("client.id");
        }
        KsqlConfig config = new KsqlConfig(map);
        Map<String, String> metricsTags = config.getStringAsMap("ksql.metrics.tags.custom");
        MetricCollectors collectors = (MetricCollectors)Objects.requireNonNull(map.get("ksql.internal.metric.collectors"));
        this.configure(id, collectors, metricsTags);
    }

    void configure(String id, MetricCollectors metricCollectors, Map<String, String> metricsTags) {
        this.metrics = metricCollectors.getMetrics();
        this.id = metricCollectors.addCollector(id, this);
        this.time = metricCollectors.getTime();
        this.metricsCollectors = metricCollectors;
        this.totalBytesSum = ConsumerCollector.configureTotalBytesSum(metricCollectors.getMetrics(), metricsTags);
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> map) {
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public ConsumerRecords<Object, Object> onConsume(ConsumerRecords<Object, Object> records) {
        this.collect(records);
        return records;
    }

    private void collect(ConsumerRecords<Object, Object> consumerRecords) {
        Stream<ConsumerRecord> stream = StreamSupport.stream(consumerRecords.spliterator(), false);
        stream.forEach(record -> this.record(record.topic().toLowerCase(), false, (ConsumerRecord<Object, Object>)record));
    }

    private void record(String topic, boolean isError, ConsumerRecord<Object, Object> record) {
        this.topicSensors.computeIfAbsent(this.getCounterKey(topic), k -> new TopicSensors(topic, this.buildSensors((String)k))).increment(record, isError);
        this.totalBytesSum.record(record == null ? 0.0 : (double)record.serializedValueSize() + (double)record.serializedKeySize());
    }

    private String getCounterKey(String topic) {
        return topic;
    }

    private List<TopicSensors.SensorMetric<ConsumerRecord<Object, Object>>> buildSensors(String key) {
        ArrayList<TopicSensors.SensorMetric<ConsumerRecord<Object, Object>>> sensors = new ArrayList<TopicSensors.SensorMetric<ConsumerRecord<Object, Object>>>();
        this.addSensor(key, CONSUMER_MESSAGES_PER_SEC, (MeasurableStat)new Rate(), sensors, false);
        this.addSensor(key, CONSUMER_TOTAL_MESSAGES, (MeasurableStat)new CumulativeSum(), sensors, false);
        this.addSensor(key, CONSUMER_TOTAL_BYTES, (MeasurableStat)new CumulativeSum(), sensors, false, r -> {
            if (r == null) {
                return 0.0;
            }
            return (double)r.serializedValueSize() + (double)r.serializedKeySize();
        });
        return sensors;
    }

    private void addSensor(String key, String metricNameString, MeasurableStat stat, List<TopicSensors.SensorMetric<ConsumerRecord<Object, Object>>> sensors, boolean isError) {
        this.addSensor(key, metricNameString, stat, sensors, isError, r -> 1.0);
    }

    private void addSensor(String key, String metricNameString, MeasurableStat stat, List<TopicSensors.SensorMetric<ConsumerRecord<Object, Object>>> sensors, boolean isError, final Function<ConsumerRecord<Object, Object>, Double> recordValue) {
        String name = "cons-" + key + "-" + metricNameString + "-" + this.id;
        MetricName metricName = new MetricName(metricNameString, CONSUMER_COLLECTOR_METRICS_GROUP_NAME, "consumer-" + name, (Map)ImmutableMap.of((Object)"key", (Object)key, (Object)"id", (Object)this.id));
        Sensor existingSensor = this.metrics.getSensor(name);
        final Sensor sensor = this.metrics.sensor(name);
        if (existingSensor == null || this.metrics.metrics().get(metricName) == null) {
            sensor.add(metricName, stat);
        }
        KafkaMetric metric = (KafkaMetric)this.metrics.metrics().get(metricName);
        sensors.add(new TopicSensors.SensorMetric<ConsumerRecord<Object, Object>>(sensor, metric, this.time, isError){

            @Override
            void record(ConsumerRecord<Object, Object> record) {
                sensor.record(((Double)recordValue.apply(record)).doubleValue());
                super.record(record);
            }
        });
    }

    public void close() {
        this.metricsCollectors.remove(this.id);
        this.topicSensors.values().forEach(v -> v.close(this.metrics));
    }

    @Override
    public Collection<TopicSensors.Stat> stats(String topic, boolean isError) {
        return MetricUtils.stats(topic, isError, this.topicSensors.values());
    }

    @Override
    public double aggregateStat(String name, boolean isError) {
        return MetricUtils.aggregateStat(name, isError, this.topicSensors.values());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " id:" + this.id + " " + this.topicSensors.keySet();
    }

    private static Sensor configureTotalBytesSum(Metrics metrics, Map<String, String> metricsTags) {
        String description = "The total number of bytes consumed across all consumers";
        Sensor sensor = metrics.sensor(CONSUMER_ALL_TOTAL_BYTES_SUM);
        sensor.add(metrics.metricName(CONSUMER_ALL_TOTAL_BYTES_SUM, CONSUMER_COLLECTOR_METRICS_GROUP_NAME, "The total number of bytes consumed across all consumers", metricsTags), (MeasurableStat)new CumulativeSum());
        return sensor;
    }
}

