/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.GenericType;
import io.confluent.ksql.function.types.LambdaType;
import io.confluent.ksql.function.types.MapType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.StructType;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlArgument;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlLambda;
import io.confluent.ksql.schema.ksql.types.SqlLambdaResolved;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlPreconditions;
import io.confluent.ksql.util.Pair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class GenericsUtil {
    private GenericsUtil() {
    }

    public static boolean isGeneric(ParamType type) {
        return type instanceof GenericType;
    }

    public static Set<ParamType> constituentGenerics(ParamType type) {
        if (type instanceof ArrayType) {
            return GenericsUtil.constituentGenerics(((ArrayType)type).element());
        }
        if (type instanceof MapType) {
            return Sets.union(GenericsUtil.constituentGenerics(((MapType)type).key()), GenericsUtil.constituentGenerics(((MapType)type).value()));
        }
        if (type instanceof StructType) {
            return ((StructType)type).getSchema().values().stream().map(GenericsUtil::constituentGenerics).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        if (type instanceof GenericType) {
            return ImmutableSet.of((Object)type);
        }
        if (type instanceof LambdaType) {
            HashSet<ParamType> inputSet = new HashSet<ParamType>();
            for (ParamType paramType : ((LambdaType)type).inputTypes()) {
                inputSet.addAll(GenericsUtil.constituentGenerics(paramType));
            }
            return Sets.union(inputSet, GenericsUtil.constituentGenerics(((LambdaType)type).returnType()));
        }
        return ImmutableSet.of();
    }

    public static boolean hasGenerics(ParamType type) {
        return !GenericsUtil.constituentGenerics(type).isEmpty();
    }

    public static SqlType applyResolved(ParamType schema, Map<GenericType, SqlType> resolved) {
        if (schema instanceof ArrayType) {
            return SqlTypes.array((SqlType)GenericsUtil.applyResolved(((ArrayType)schema).element(), resolved));
        }
        if (schema instanceof MapType) {
            MapType mapType = (MapType)schema;
            SqlType keyType = GenericsUtil.applyResolved(mapType.key(), resolved);
            SqlType valueType = GenericsUtil.applyResolved(mapType.value(), resolved);
            return SqlTypes.map((SqlType)keyType, (SqlType)valueType);
        }
        if (schema instanceof StructType) {
            SqlStruct.Builder struct = SqlTypes.struct();
            ((StructType)schema).getSchema().forEach((fieldName, type) -> struct.field(fieldName, GenericsUtil.applyResolved(type, resolved)));
            return struct.build();
        }
        if (schema instanceof GenericType) {
            SqlType instance = resolved.get(schema);
            if (instance == null) {
                throw new KsqlException("Could not find mapping for generic type: " + schema);
            }
            return instance;
        }
        return SchemaConverters.functionToSqlConverter().toSqlType(schema);
    }

    public static Map<GenericType, SqlType> reserveGenerics(ParamType schema, SqlArgument instance) {
        HashMap<GenericType, SqlType> genericMapping = new HashMap<GenericType, SqlType>();
        Pair<Boolean, Optional<KsqlException>> result = GenericsUtil.reserveGenerics(schema, instance, genericMapping);
        if (!result.getLeft().booleanValue() && result.getRight().isPresent()) {
            throw result.getRight().get();
        }
        return ImmutableMap.copyOf(genericMapping);
    }

    public static Pair<Boolean, Optional<KsqlException>> reserveGenerics(ParamType schema, SqlArgument instance, Map<GenericType, SqlType> reservedGenerics) {
        ArrayList<Map.Entry<GenericType, SqlType>> genericMapping = new ArrayList<Map.Entry<GenericType, SqlType>>();
        boolean success = GenericsUtil.resolveGenerics(genericMapping, schema, instance);
        if (!success) {
            return new Pair<Boolean, Optional<KsqlException>>(false, Optional.of(new KsqlException(String.format("Cannot infer generics for %s from %s because they do not have the same schema structure.", schema, instance))));
        }
        for (Map.Entry entry : genericMapping) {
            SqlType old = reservedGenerics.putIfAbsent((GenericType)entry.getKey(), (SqlType)entry.getValue());
            if (old == null || old.equals(entry.getValue())) continue;
            return new Pair<Boolean, Optional<KsqlException>>(false, Optional.of(new KsqlException(String.format("Found invalid instance of generic schema when mapping %s to %s. Cannot map %s to both %s and %s", schema, instance, entry.getKey(), old, entry.getValue()))));
        }
        return new Pair<Boolean, Object>(true, null);
    }

    private static boolean resolveGenerics(List<Map.Entry<GenericType, SqlType>> mapping, ParamType schema, SqlArgument instance) {
        if (!GenericsUtil.isGeneric(schema) && !GenericsUtil.matches(schema, instance)) {
            return false;
        }
        if (!GenericsUtil.hasGenerics(schema)) {
            return true;
        }
        KsqlPreconditions.checkArgument(GenericsUtil.isGeneric(schema) || GenericsUtil.matches(schema, instance), "Cannot resolve generics if the schema and instance have differing types: " + schema + " vs. " + instance);
        if (schema instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)schema;
            SqlLambda sqlLambda = instance.getSqlLambdaOrThrow();
            if (lambdaType.inputTypes().size() == sqlLambda.getNumInputs().intValue()) {
                if (sqlLambda instanceof SqlLambdaResolved) {
                    SqlLambdaResolved sqlLambdaResolved = (SqlLambdaResolved)sqlLambda;
                    int i = 0;
                    for (ParamType paramType : lambdaType.inputTypes()) {
                        if (!GenericsUtil.resolveGenerics(mapping, paramType, SqlArgument.of((SqlType)((SqlType)sqlLambdaResolved.getInputType().get(i))))) {
                            return false;
                        }
                        ++i;
                    }
                    return GenericsUtil.resolveGenerics(mapping, lambdaType.returnType(), SqlArgument.of((SqlType)sqlLambdaResolved.getReturnType()));
                }
                return true;
            }
            return false;
        }
        SqlType sqlType = instance.getSqlTypeOrThrow();
        if (GenericsUtil.isGeneric(schema)) {
            mapping.add(new AbstractMap.SimpleEntry<GenericType, SqlType>((GenericType)schema, sqlType));
        }
        if (schema instanceof ArrayType) {
            SqlArray sqlArray = (SqlArray)sqlType;
            return GenericsUtil.resolveGenerics(mapping, ((ArrayType)schema).element(), SqlArgument.of((SqlType)sqlArray.getItemType()));
        }
        if (schema instanceof MapType) {
            SqlMap sqlMap = (SqlMap)sqlType;
            MapType mapType = (MapType)schema;
            return GenericsUtil.resolveGenerics(mapping, mapType.key(), SqlArgument.of((SqlType)sqlMap.getKeyType())) && GenericsUtil.resolveGenerics(mapping, mapType.value(), SqlArgument.of((SqlType)sqlMap.getValueType()));
        }
        if (schema instanceof StructType) {
            throw new KsqlException("Generic STRUCT is not yet supported");
        }
        return true;
    }

    private static boolean matches(ParamType schema, SqlArgument instance) {
        if (instance.getSqlLambda().isPresent()) {
            return schema instanceof LambdaType;
        }
        ParamType instanceParamType = SchemaConverters.sqlToFunctionConverter().toFunctionType(instance.getSqlTypeOrThrow());
        return schema.getClass() == instanceParamType.getClass();
    }
}

