/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.sqlgenerator;

import java.util.ArrayList;
import java.util.Iterator;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.core.CreateTableStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class BigQueryCreateTableGenerator
extends CreateTableGenerator {
    public int getPriority() {
        return 510;
    }

    public boolean supports(CreateTableStatement statement, Database database) {
        return database instanceof BigQueryDatabase;
    }

    public Sql[] generateSql(CreateTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ArrayList<UnparsedSql> additionalSql = new ArrayList<UnparsedSql>();
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE TABLE ").append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName())).append(" ");
        buffer.append("(");
        Iterator columnIterator = statement.getColumns().iterator();
        while (columnIterator.hasNext()) {
            String column = (String)columnIterator.next();
            DatabaseDataType columnType = null;
            if (statement.getColumnTypes().get(column) != null) {
                columnType = ((LiquibaseDataType)statement.getColumnTypes().get(column)).toDatabaseDataType(database);
            }
            if (columnType == null) {
                buffer.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), column, false));
            } else {
                buffer.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), column, !statement.isComputed(column)));
                buffer.append(" ").append(columnType);
            }
            if (columnType != null && !columnType.isAutoIncrement() && statement.getDefaultValue(column) != null) {
                Object defaultValue = statement.getDefaultValue(column);
                if (defaultValue instanceof DatabaseFunction) {
                    buffer.append(database.generateDatabaseFunctionValue((DatabaseFunction)defaultValue));
                } else {
                    buffer.append(((LiquibaseDataType)statement.getColumnTypes().get(column)).objectToSql(defaultValue, database));
                }
            }
            if (statement.getNotNullColumns().get(column) != null) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Not null constraints are not supported by BigQuery");
            }
            if (!columnIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(",");
        PrimaryKeyConstraint primaryKeyConstraint = statement.getPrimaryKeyConstraint();
        if (primaryKeyConstraint != null) {
            buffer.append(" PRIMARY KEY (");
            for (int i = 0; i < primaryKeyConstraint.getColumns().size(); ++i) {
                String primaryKeyColumnName = (String)primaryKeyConstraint.getColumns().get(i);
                buffer.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), primaryKeyColumnName));
                if (i >= primaryKeyConstraint.getColumns().size() - 1) continue;
                buffer.append(", ");
            }
            buffer.append(")").append(" NOT ENFORCED").append(",");
        }
        for (ForeignKeyConstraint fkConstraint : statement.getForeignKeyConstraints()) {
            if (fkConstraint.getForeignKeyName() != null) {
                buffer.append(" CONSTRAINT ");
                buffer.append(database.escapeConstraintName(fkConstraint.getForeignKeyName()));
            }
            String referencesString = fkConstraint.getReferences();
            buffer.append(" FOREIGN KEY (").append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), fkConstraint.getColumn())).append(") REFERENCES ");
            if (referencesString != null) {
                if (!referencesString.contains(".") && database.getDefaultSchemaName() != null && database.getOutputDefaultSchema() && (database.supports(Schema.class) || database.supports(Catalog.class))) {
                    referencesString = database.escapeObjectName(database.getDefaultSchemaName(), Schema.class) + "." + referencesString;
                }
                buffer.append(referencesString);
            } else {
                buffer.append(database.escapeObjectName(fkConstraint.getReferencedTableCatalogName(), fkConstraint.getReferencedTableSchemaName(), fkConstraint.getReferencedTableName(), Table.class)).append("(").append(database.escapeColumnNameList(fkConstraint.getReferencedColumnNames())).append(")");
            }
            buffer.append(" NOT ENFORCED");
            buffer.append(",");
        }
        String sql = buffer.toString().replaceFirst(",\\s*$", "") + ")";
        additionalSql.add(0, new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedTable(statement)}));
        return additionalSql.toArray(new Sql[0]);
    }
}

