/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.model.data;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentChars;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class OracleContentJSON
extends JDBCContentChars {
    private static final byte[] OSON_MAGIC = new byte[]{-1, 74, 90};
    private static final String JSON_FACTORY_CLASS = "oracle.sql.json.OracleJsonFactory";
    private static final String JSON_FACTORY_CREATE_TEXT_PARSER = "createJsonTextParser";
    private static final String JSON_FACTORY_CREATE_BINARY_PARSER = "createJsonBinaryParser";
    private static final String JSON_FACTORY_CREATE_TEXT_GENERATOR = "createJsonTextGenerator";
    private static final String JSON_FACTORY_CREATE_BINARY_GENERATOR = "createJsonBinaryGenerator";
    private static final String JSON_GENERATOR_CLASS = "oracle.sql.json.OracleJsonGenerator";
    private static final String JSON_GENERATOR_WRITE_PARSER = "writeParser";

    public OracleContentJSON(@NotNull DBCExecutionContext context, @NotNull String data) {
        super(context, data);
    }

    public OracleContentJSON(@NotNull OracleContentJSON source) {
        super((JDBCContentChars)source);
    }

    @Nullable
    public static OracleContentJSON tryFrom(@NotNull JDBCSession session, @Nullable Blob blob) throws DBCException {
        block12: {
            try {
                if (blob != null && blob.length() >= 4L && Arrays.equals(blob.getBytes(1L, 3), OSON_MAGIC)) break block12;
                return null;
            }
            catch (Throwable e) {
                throw new DBCException("Error reading JSON", e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_6 = null;
        try (InputStream is = blob.getBinaryStream();){
            OracleContentJSON.convertJson(session, is, os, false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new OracleContentJSON((DBCExecutionContext)session.getExecutionContext(), os.toString(StandardCharsets.UTF_8));
    }

    @NotNull
    private Blob convertIntoBlob(@NotNull JDBCSession session) throws DBCException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = this.getContentStream();){
                OracleContentJSON.convertJson(session, is, os, true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Blob blob = session.getOriginal().createBlob();
            blob.setBytes(1L, os.toByteArray());
            return blob;
        }
        catch (Throwable e) {
            throw new DBCException("Error writing JSON", e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement stmt, DBSTypedObject columnType, int paramIndex) throws DBCException {
        try {
            stmt.setBlob(paramIndex, this.convertIntoBlob(session));
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public String getDisplayString(@NotNull DBDDisplayFormat format) {
        return format == DBDDisplayFormat.EDIT ? this.data : CommonUtils.compactWhiteSpaces((String)this.data);
    }

    public JDBCContentChars cloneValue(DBRProgressMonitor monitor) {
        return new OracleContentJSON(this);
    }

    private static void convertJson(@NotNull JDBCSession session, @NotNull InputStream is, @NotNull OutputStream os, boolean fromText) throws Throwable {
        ClassLoader classLoader = session.getOriginal().getClass().getClassLoader();
        Class<?> OracleJsonFactory = Class.forName(JSON_FACTORY_CLASS, true, classLoader);
        Method OracleJsonFactory_createJsonParser = OracleJsonFactory.getDeclaredMethod(fromText ? JSON_FACTORY_CREATE_TEXT_PARSER : JSON_FACTORY_CREATE_BINARY_PARSER, InputStream.class);
        Method OracleJsonFactory_createJsonGenerator = OracleJsonFactory.getDeclaredMethod(fromText ? JSON_FACTORY_CREATE_BINARY_GENERATOR : JSON_FACTORY_CREATE_TEXT_GENERATOR, OutputStream.class);
        Class<?> OracleJsonGenerator = Class.forName(JSON_GENERATOR_CLASS, true, classLoader);
        Method OracleJsonGenerator_writeParser = OracleJsonGenerator.getDeclaredMethod(JSON_GENERATOR_WRITE_PARSER, Object.class);
        Object factory = OracleJsonFactory.getConstructor(new Class[0]).newInstance(new Object[0]);
        Throwable throwable = null;
        Object var12_13 = null;
        try (Closeable parser = (Closeable)OracleJsonFactory_createJsonParser.invoke(factory, is);){
            Throwable throwable2 = null;
            Object var15_18 = null;
            try (Closeable generator = (Closeable)OracleJsonFactory_createJsonGenerator.invoke(factory, os);){
                OracleJsonGenerator_writeParser.invoke((Object)generator, parser);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

