/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.bigquery.model;

import com.dbeaver.db.bigquery.model.BigQueryDataset;
import com.dbeaver.db.bigquery.model.BigQueryDialect;
import com.dbeaver.db.bigquery.model.BigQueryTableColumn;
import com.dbeaver.db.bigquery.model.BigQueryUniqueKey;
import com.dbeaver.db.bigquery.model.BigQueryUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableForeignKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class BigQueryTable
extends GenericTable
implements DBPImageProvider {
    private static final Log log = Log.getLog(BigQueryTable.class);

    public BigQueryTable(@NotNull GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Property(viewable=true, order=5)
    public boolean isClustered(@Nullable DBRProgressMonitor monitor) {
        if (monitor == null) {
            return false;
        }
        try {
            BigQueryTableColumn column;
            Iterator iterator = CommonUtils.safeCollection(this.getAttributes(monitor)).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((column = (BigQueryTableColumn)((Object)iterator.next())).getClusteringOrderPosition() == 0);
            return true;
        }
        catch (DBException e) {
            log.error((Object)"Error reading BigQuery table columns", (Throwable)e);
        }
        return false;
    }

    @NotNull
    public String[] getSupportedFeatures() {
        if (BigQueryUtils.getCurrentDialect((DBSObject)this) == BigQueryDialect.BIG_QUERY) {
            return new String[]{"data.count", "data.filter", "data.search"};
        }
        return new String[]{"data.count", "data.filter", "data.search", "data.insert", "data.update", "data.delete"};
    }

    public BigQueryDataset getSchema() {
        return (BigQueryDataset)super.getSchema();
    }

    @Nullable
    public DBPImage getObjectImage() {
        return DBIcon.TREE_TABLE;
    }

    @Nullable
    public List<BigQueryTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAttributes(monitor);
    }

    @Association
    public Collection<BigQueryUniqueKey> getUniqueKeys(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().getUniqueConstraintCache().getTypedObjects(monitor, (DBSObject)this.getSchema(), (DBSObject)this, BigQueryUniqueKey.class);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.getSchema().getUniqueConstraintCache().clearObjectCache((DBSObject)this);
        return super.refreshObject(monitor);
    }

    @Nullable
    public List<GenericUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return new ArrayList<GenericUniqueKey>(this.getUniqueKeys(monitor));
    }

    public Collection<? extends GenericTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAssociations(monitor);
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source, @NotNull Map<String, Object> options) throws DBCException {
        if (BigQueryUtils.getCurrentDialect((DBSObject)this) == BigQueryDialect.BIG_QUERY) {
            throw new DBCException("Data INSERT is not supported in Legacy mode");
        }
        return super.insertData(session, attributes, keysReceiver, source, options);
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] updateAttributes, @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source) throws DBCException {
        if (BigQueryUtils.getCurrentDialect((DBSObject)this) == BigQueryDialect.BIG_QUERY) {
            throw new DBCException("Data UPDATE is not supported in Legacy mode");
        }
        return super.updateData(session, updateAttributes, keyAttributes, keysReceiver, source);
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] keyAttributes, @NotNull DBCExecutionSource source) throws DBCException {
        if (BigQueryUtils.getCurrentDialect((DBSObject)this) == BigQueryDialect.BIG_QUERY) {
            throw new DBCException("Data DELETE is not supported in Legacy mode");
        }
        return super.deleteData(session, keyAttributes, source);
    }
}

