/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.registry;

import com.dbeaver.ee.scmp.registry.SCMPDiffEngineDescriptor;
import com.dbeaver.ee.scmp.registry.SCMPReportEngineDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;

public class SCMPEngineRegistry {
    private static final Log log = Log.getLog(SCMPEngineRegistry.class);
    public static final String EXTENSION_ID = "com.dbeaver.scmp.engine";
    private static final String TAG_DIFF_ENGINE = "diffEngine";
    private static final String TAG_REPORT_ENGINE = "reportEngine";
    private static SCMPEngineRegistry instance = null;
    private final List<SCMPDiffEngineDescriptor> diffEngines = new ArrayList<SCMPDiffEngineDescriptor>();
    private final List<SCMPReportEngineDescriptor> reportEngines = new ArrayList<SCMPReportEngineDescriptor>();

    public static synchronized SCMPEngineRegistry getInstance() {
        if (instance == null) {
            instance = new SCMPEngineRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SCMPEngineRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_DIFF_ENGINE.equals(ext.getName())) {
                this.diffEngines.add(new SCMPDiffEngineDescriptor(ext));
            } else if (TAG_REPORT_ENGINE.equals(ext.getName())) {
                this.reportEngines.add(new SCMPReportEngineDescriptor(ext));
            }
            ++n2;
        }
    }

    public void dispose() {
        this.diffEngines.clear();
    }

    public List<SCMPDiffEngineDescriptor> getDiffEngines() {
        return new ArrayList<SCMPDiffEngineDescriptor>(this.diffEngines);
    }

    public SCMPDiffEngineDescriptor getDefaultDiffEngine() {
        return this.diffEngines.get(0);
    }

    public SCMPDiffEngineDescriptor getDiffEngine(String id) {
        for (SCMPDiffEngineDescriptor engine : this.diffEngines) {
            if (!engine.getId().equals(id)) continue;
            return engine;
        }
        return null;
    }

    public List<SCMPReportEngineDescriptor> getReportEngines() {
        return this.reportEngines;
    }

    public SCMPReportEngineDescriptor getDefaultReportEngine() {
        return this.reportEngines.get(0);
    }

    public SCMPReportEngineDescriptor getReportEngine(String id) {
        for (SCMPReportEngineDescriptor engine : this.reportEngines) {
            if (!engine.getId().equals(id)) continue;
            return engine;
        }
        return null;
    }
}

