/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.structure.core.View;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public enum LBObjectDataType {
    SCHEMA,
    TABLE,
    VIEW,
    INDEX,
    PROCEDURE,
    SEQUENCE,
    UNKNOWN;


    public static LBObjectDataType fromDBSObject(DBSObject object) {
        if (object instanceof DBSSchema) {
            return SCHEMA;
        }
        if (object instanceof DBSTable) {
            return TABLE;
        }
        if (object instanceof DBSView) {
            return VIEW;
        }
        if (object instanceof DBSProcedure) {
            return PROCEDURE;
        }
        if (object instanceof DBSSequence) {
            return SEQUENCE;
        }
        if (object instanceof DBSTableIndex) {
            return INDEX;
        }
        return UNKNOWN;
    }

    public static boolean isTableAttributes(DatabaseObject object) {
        return object instanceof Column || object instanceof ForeignKey || object instanceof PrimaryKey || object instanceof UniqueConstraint || object instanceof Index;
    }

    public static LBObjectDataType fromDatabaseObject(DatabaseObject object) {
        if (object instanceof Schema) {
            return SCHEMA;
        }
        if (object instanceof Table) {
            return TABLE;
        }
        if (object instanceof View) {
            return VIEW;
        }
        if (object instanceof StoredProcedure) {
            return PROCEDURE;
        }
        if (object instanceof Sequence) {
            return SEQUENCE;
        }
        if (object instanceof DBSTableIndex) {
            return INDEX;
        }
        return UNKNOWN;
    }
}

