/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.udbt.protocol;

import com.dbeaver.model.udbt.protocol.UdbtWsConstants;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;

public final class UdbtWsListener
extends Endpoint {
    private static final Log log = Log.getLog(UdbtWsListener.class);
    private static final int BUFFER_CAPACITY = 16384;
    private final ByteBuffer inbound = ByteBuffer.allocate(16384);
    private final ByteBuffer outbound = ByteBuffer.allocate(16384);
    private final Lock lock = new ReentrantLock();
    private final ExecutorService executor;
    private final Selector selector;
    private SocketChannel channel;
    private UUID id;
    private Session session;
    private final Consumer<UdbtWsListener> afterOpenCallback;

    public UdbtWsListener(@NotNull ExecutorService executor, @NotNull Consumer<UdbtWsListener> afterOpenCallback) throws IOException {
        this.executor = executor;
        this.selector = Selector.open();
        this.afterOpenCallback = afterOpenCallback;
    }

    public UdbtWsListener(@NotNull ExecutorService executor, @NotNull SocketChannel channel, @NotNull UUID id) throws IOException {
        this.executor = executor;
        this.channel = channel;
        this.id = id;
        this.selector = Selector.open();
        this.afterOpenCallback = null;
    }

    public void onOpen(Session session, EndpointConfig config) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[UDBT] Connection opened: " + String.valueOf(this.id)));
        }
        this.init(session);
        this.session = session;
        this.session.setMaxBinaryMessageBufferSize(16384);
        this.session.setMaxIdleTimeout(UdbtWsConstants.IDLE_TIMEOUT.toMillis());
        this.session.addMessageHandler(ByteBuffer.class, (MessageHandler.Whole)new BinaryHandler());
        if (this.afterOpenCallback != null) {
            this.afterOpenCallback.accept(this);
        }
        this.executor.submit(() -> {
            Thread.currentThread().setName(((Object)((Object)this)).getClass().getSimpleName() + " " + Integer.toHexString(((Object)((Object)this)).hashCode()) + " S->C");
            this.process(this.channel);
            return null;
        });
    }

    public void onError(Session session, Throwable thr) {
        super.onError(session, thr);
    }

    private void init(Session session) {
        Map properties = session.getUserProperties();
        if (properties.containsKey("udbt-id")) {
            this.id = (UUID)properties.get("udbt-id");
        }
        if (properties.containsKey("udbt-channel")) {
            this.channel = (SocketChannel)properties.get("udbt-channel");
        }
    }

    public boolean isOpen() {
        return this.session != null && this.session.isOpen();
    }

    @Nullable
    public Session getSession() {
        return this.session;
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[UDBT] Connection closed: " + String.valueOf(this.id) + ", status: " + String.valueOf(closeReason.getCloseCode()) + ", reason: " + closeReason.getReasonPhrase()));
        }
        this.closeUdbtSession();
    }

    private void closeUdbtSession() {
        if (this.isOpen()) {
            try {
                this.session.close();
            }
            catch (IOException e) {
                log.error((Object)("[UDBT] Error closing websocket session: " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            this.selector.wakeup();
            this.selector.close();
        }
        catch (IOException e) {
            log.error((Object)"[UDBT] Failed to close selector", (Throwable)e);
        }
    }

    private void write(@NotNull ByteBuffer src) {
        if (!this.isOpen()) {
            log.error((Object)"[UDBT] Connection not open");
        }
        if (log.isTraceEnabled()) {
            int remaining = src.remaining();
            log.trace((Object)("[UDBT] Sent " + remaining + " bytes"));
        }
        byte[] data = new byte[src.remaining()];
        src.get(data);
        try {
            this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(data));
        }
        catch (IOException e) {
            log.error((Object)("[UDBT] Failed to send " + data.length + " bytes: " + e.getMessage()), (Throwable)e);
        }
    }

    private void process(@NotNull SocketChannel channel) throws IOException {
        channel.configureBlocking(false);
        channel.register(this.selector, 1);
        while (this.isOpen()) {
            this.selector.select();
            if (!this.isOpen()) break;
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                if (key.isReadable()) {
                    this.outbound.clear();
                    int readBytes = channel.read(this.outbound);
                    if (readBytes < 0) {
                        log.trace((Object)("Invalid data received from the server, force close connection " + String.valueOf(this.id)));
                        this.closeUdbtSession();
                    }
                    if (readBytes > 0) {
                        this.outbound.flip();
                        this.write(this.outbound);
                    }
                }
                it.remove();
            }
            if (this.inbound.position() <= 0) continue;
            this.lock.lock();
            try {
                this.inbound.flip();
                int writtenBytes = channel.write(this.inbound);
                if (writtenBytes < 0) {
                    log.trace((Object)("Invalid data sent to the server, force close connection " + String.valueOf(this.id)));
                    this.closeUdbtSession();
                }
                this.inbound.compact();
            }
            finally {
                this.lock.unlock();
            }
        }
        log.debug((Object)"[UDBT] Exiting the loop due to connection closed");
    }

    public void ping() {
        if (!this.isOpen()) {
            return;
        }
        log.trace((Object)("[UDBT] Sending ping: " + String.valueOf(this.id)));
        log.trace((Object)"[UDBT] Sent ping");
        try {
            this.session.getBasicRemote().sendPing(ByteBuffer.wrap(("PING UDBT " + System.currentTimeMillis()).getBytes()));
        }
        catch (IOException e) {
            log.error((Object)"[UDBT] Error sending ping", (Throwable)e);
        }
    }

    private static void transfer(@NotNull ByteBuffer src, @NotNull ByteBuffer dst) {
        int length = Math.min(src.remaining(), dst.remaining());
        if (length == 0) {
            return;
        }
        dst.put(dst.position(), src, src.position(), length);
        dst.position(dst.position() + length);
        src.position(src.position() + length);
    }

    private class BinaryHandler
    implements MessageHandler.Whole<ByteBuffer> {
        private BinaryHandler() {
        }

        public void onMessage(ByteBuffer payload) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("[UDBT] Received " + payload.remaining() + " bytes"));
            }
            while (payload.hasRemaining() && UdbtWsListener.this.isOpen()) {
                UdbtWsListener.this.lock.lock();
                try {
                    UdbtWsListener.transfer(payload, UdbtWsListener.this.inbound);
                    UdbtWsListener.this.selector.wakeup();
                }
                finally {
                    UdbtWsListener.this.lock.unlock();
                }
            }
        }
    }
}

