/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CouchbaseNode
implements DBSObject {
    private static final Log log = Log.getLog(CouchbaseNode.class);
    private static final String CAT_HEALTH = "Health";
    private final CouchbaseDataSource dataSource;
    private final JsonObject nodeDesc;

    public CouchbaseNode(CouchbaseDataSource dataSource, JsonObject nodeDesc) {
        this.dataSource = dataSource;
        this.nodeDesc = nodeDesc;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.nodeDesc.getString("hostname");
    }

    @Property(viewable=true, editable=true, order=2)
    public String getUUID() {
        return this.nodeDesc.getString("nodeUUID");
    }

    @Property(viewable=true, editable=true, order=3)
    public String getStatus() {
        return this.nodeDesc.getString("status");
    }

    @Property(viewable=true, editable=true, order=4)
    public String getVersion() {
        return this.nodeDesc.getString("version");
    }

    @Property(viewable=true, editable=true, order=5)
    public String getOS() {
        return this.nodeDesc.getString("os");
    }

    @Property(viewable=true, editable=true, order=6)
    public String getUptime() {
        return this.nodeDesc.getString("uptime");
    }

    @Property(viewable=true, editable=true, category="Health", order=2)
    public Integer getCpuCount() {
        return this.nodeDesc.getInt("cpuCount");
    }

    @Property(viewable=true, editable=true, category="Health", order=20)
    public Number getMemoryTotal() {
        return this.nodeDesc.getLong("memoryTotal");
    }

    @Property(viewable=true, editable=true, category="Health", order=21)
    public Number getMemoryFree() {
        return this.nodeDesc.getLong("memoryFree");
    }

    @Property(viewable=true, editable=true, category="Health", order=22)
    public Number getSwapMemoryReserved() {
        return this.nodeDesc.getLong("swapTotal");
    }

    @Property(viewable=true, editable=true, category="Health", order=23)
    public Number getSwapMemoryAllocated() {
        return this.nodeDesc.getLong("swapUsed");
    }

    @Property(viewable=true, editable=true, category="Statistics", order=51)
    public JsonObject getStorageConf() {
        return this.nodeDesc.getObject("storageConf");
    }

    @Property(viewable=true, editable=true, category="Statistics", order=53)
    public JsonArray getServices() {
        return this.nodeDesc.getArray("services");
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return true;
    }
}

