/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.management.implementation.polling.Error;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.management.implementation.polling.PollingState;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class PollOperation {
    private static final ClientLogger LOGGER = new ClientLogger(PollOperation.class);
    private static final LongRunningOperationStatus LRO_CANCELLED = LongRunningOperationStatus.fromString((String)"Cancelled", (boolean)true);

    public static <T> Function<PollingContext<PollResult<T>>, Mono<PollResponse<PollResult<T>>>> pollFunction(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type pollResultType, Context context) {
        return pollingContext -> {
            PollingState pollingState = PollingState.from(serializerAdapter, pollingContext);
            if (pollingState.getOperationStatus().isComplete()) {
                return PollOperation.pollResponseMonoFromPollingState(serializerAdapter, pollResultType, pollingState);
            }
            return PollOperation.doSinglePoll(pipeline, pollingState, context).flatMap(updatedState -> {
                updatedState.store(pollingContext);
                return PollOperation.pollResponseMonoFromPollingState(serializerAdapter, pollResultType, updatedState);
            });
        };
    }

    public static <T> BiFunction<PollingContext<PollResult<T>>, PollResponse<PollResult<T>>, Mono<PollResult<T>>> cancelFunction(Context context) {
        return (pollingContext, response) -> Mono.empty();
    }

    public static <T, U> Function<PollingContext<PollResult<T>>, Mono<U>> fetchResultFunction(SerializerAdapter serializerAdapter, HttpPipeline pipeline, Type finalResultType, Context context) {
        return pollingContext -> {
            PollingState pollingState = PollingState.from(serializerAdapter, pollingContext);
            FinalResult finalResult = pollingState.getFinalResult();
            if (finalResult == null) {
                return Mono.empty();
            }
            String value = finalResult.getResult();
            if (value != null) {
                Object result = PollOperation.deserialize(serializerAdapter, value, finalResultType);
                return result != null ? Mono.just(result) : Mono.empty();
            }
            return FluxUtil.fluxContext(fluxContext -> {
                fluxContext = CoreUtils.mergeContexts((Context)fluxContext, (Context)context);
                return pipeline.send(PollOperation.decorateRequest(new HttpRequest(HttpMethod.GET, finalResult.getResultUri())), fluxContext).flux();
            }).next().flatMap(response -> response.getBodyAsString()).flatMap(body -> {
                Object result = PollOperation.deserialize(serializerAdapter, body, finalResultType);
                return result != null ? Mono.just(result) : Mono.empty();
            });
        };
    }

    private static <T> Mono<PollResponse<PollResult<T>>> errorPollResponseMono(LongRunningOperationStatus opStatus, Error error) {
        PollResult pollResult = new PollResult(new PollResult.Error(error.getMessage(), error.getResponseStatusCode(), new HttpHeaders(error.getResponseHeaders()), error.getResponseBody()));
        return Mono.just((Object)new PollResponse(opStatus, pollResult));
    }

    private static <T> Mono<PollResponse<PollResult<T>>> pollResponseMono(SerializerAdapter serializerAdapter, LongRunningOperationStatus opStatus, String pollResponseBody, Type pollResultType, Duration pollDelay) {
        Object result = PollOperation.deserialize(serializerAdapter, pollResponseBody, pollResultType);
        return Mono.just((Object)new PollResponse(opStatus, new PollResult(result), pollDelay));
    }

    private static Mono<PollingState> doSinglePoll(HttpPipeline pipeline, PollingState pollingState, Context context) {
        return FluxUtil.fluxContext(fluxContext -> {
            fluxContext = CoreUtils.mergeContexts((Context)fluxContext, (Context)context);
            return pipeline.send(PollOperation.decorateRequest(new HttpRequest(HttpMethod.GET, pollingState.getPollUrl())), fluxContext).flux();
        }).next().flatMap(response -> response.getBodyAsString().map(body -> pollingState.update(response.getStatusCode(), response.getHeaders(), (String)body)).switchIfEmpty(Mono.fromSupplier(() -> pollingState.update(response.getStatusCode(), response.getHeaders(), null))));
    }

    private static <T> Mono<PollResponse<PollResult<T>>> pollResponseMonoFromPollingState(SerializerAdapter serializerAdapter, Type pollResultType, PollingState pollingState) {
        if (pollingState.getOperationStatus().isComplete()) {
            if (pollingState.getOperationStatus() == LongRunningOperationStatus.FAILED || pollingState.getOperationStatus() == LRO_CANCELLED) {
                Error lroInitError = pollingState.getSynchronouslyFailedLroError();
                if (lroInitError != null) {
                    return PollOperation.errorPollResponseMono(pollingState.getOperationStatus(), lroInitError);
                }
                Error pollError = pollingState.getPollError();
                if (pollError != null) {
                    return PollOperation.errorPollResponseMono(pollingState.getOperationStatus(), pollError);
                }
                throw new IllegalStateException("Either LroError or PollError mustbe set when OperationStatus is in Failed|Cancelled State.");
            }
            return PollOperation.pollResponseMono(serializerAdapter, pollingState.getOperationStatus(), pollingState.getLastResponseBody(), pollResultType, pollingState.getPollDelay());
        }
        return PollOperation.pollResponseMono(serializerAdapter, pollingState.getOperationStatus(), pollingState.getLastResponseBody(), pollResultType, pollingState.getPollDelay());
    }

    private static HttpRequest decorateRequest(HttpRequest httpRequest) {
        return httpRequest.setHeader(HttpHeaderName.ACCEPT, "application/json");
    }

    public static <U> U deserialize(SerializerAdapter serializerAdapter, String value, Type type) {
        if (CoreUtils.isNullOrEmpty((CharSequence)value)) {
            LOGGER.verbose("Ignoring decoding of null or empty value to:" + type);
            return null;
        }
        try {
            return (U)serializerAdapter.deserialize(value, type, SerializerEncoding.JSON);
        }
        catch (IOException | RuntimeException ioe) {
            LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Unable to decode '" + value + "' to: " + type, ioe));
            return null;
        }
    }
}

