/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.ServerParametersClient;
import com.azure.resourcemanager.mysql.fluent.models.ConfigurationListResultInner;
import com.azure.resourcemanager.mysql.implementation.ConfigurationListResultImpl;
import com.azure.resourcemanager.mysql.models.ConfigurationListResult;
import com.azure.resourcemanager.mysql.models.ServerParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ServerParametersImpl
implements ServerParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerParametersImpl.class);
    private final ServerParametersClient innerClient;
    private final MySqlManager serviceManager;

    public ServerParametersImpl(ServerParametersClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ConfigurationListResult listUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value) {
        ConfigurationListResultInner inner = this.serviceClient().listUpdateConfigurations(resourceGroupName, serverName, value);
        if (inner != null) {
            return new ConfigurationListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ConfigurationListResult listUpdateConfigurations(String resourceGroupName, String serverName, ConfigurationListResultInner value, Context context) {
        ConfigurationListResultInner inner = this.serviceClient().listUpdateConfigurations(resourceGroupName, serverName, value, context);
        if (inner != null) {
            return new ConfigurationListResultImpl(inner, this.manager());
        }
        return null;
    }

    private ServerParametersClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

