/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.mysql.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.mysql.fluent.models.QueryPerformanceInsightResetDataResultInner;
import com.azure.resourcemanager.mysql.implementation.MySqlManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ClientLogger logger = new ClientLogger(ResourceProvidersClientImpl.class);
    private final ResourceProvidersService service;
    private final MySqlManagementClientImpl client;

    ResourceProvidersClientImpl(MySqlManagementClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryPerformanceInsightResetDataResultInner>> resetQueryPerformanceInsightDataWithResponseAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String apiVersion = "2018-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetQueryPerformanceInsightData(this.client.getEndpoint(), "2018-06-01", this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryPerformanceInsightResetDataResultInner>> resetQueryPerformanceInsightDataWithResponseAsync(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        String apiVersion = "2018-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resetQueryPerformanceInsightData(this.client.getEndpoint(), "2018-06-01", this.client.getSubscriptionId(), resourceGroupName, serverName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QueryPerformanceInsightResetDataResultInner> resetQueryPerformanceInsightDataAsync(String resourceGroupName, String serverName) {
        return this.resetQueryPerformanceInsightDataWithResponseAsync(resourceGroupName, serverName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((QueryPerformanceInsightResetDataResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryPerformanceInsightResetDataResultInner resetQueryPerformanceInsightData(String resourceGroupName, String serverName) {
        return (QueryPerformanceInsightResetDataResultInner)this.resetQueryPerformanceInsightDataAsync(resourceGroupName, serverName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueryPerformanceInsightResetDataResultInner> resetQueryPerformanceInsightDataWithResponse(String resourceGroupName, String serverName, Context context) {
        return (Response)this.resetQueryPerformanceInsightDataWithResponseAsync(resourceGroupName, serverName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createRecommendedActionSessionWithResponseAsync(String resourceGroupName, String serverName, String advisorName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (advisorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter advisorName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2018-06-01";
        return FluxUtil.withContext(context -> this.service.createRecommendedActionSession(this.client.getEndpoint(), "2018-06-01", this.client.getSubscriptionId(), resourceGroupName, serverName, advisorName, databaseName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createRecommendedActionSessionWithResponseAsync(String resourceGroupName, String serverName, String advisorName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (advisorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter advisorName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String apiVersion = "2018-06-01";
        context = this.client.mergeContext(context);
        return this.service.createRecommendedActionSession(this.client.getEndpoint(), "2018-06-01", this.client.getSubscriptionId(), resourceGroupName, serverName, advisorName, databaseName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCreateRecommendedActionSessionAsync(String resourceGroupName, String serverName, String advisorName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createRecommendedActionSessionWithResponseAsync(resourceGroupName, serverName, advisorName, databaseName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCreateRecommendedActionSessionAsync(String resourceGroupName, String serverName, String advisorName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createRecommendedActionSessionWithResponseAsync(resourceGroupName, serverName, advisorName, databaseName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreateRecommendedActionSession(String resourceGroupName, String serverName, String advisorName, String databaseName) {
        return this.beginCreateRecommendedActionSessionAsync(resourceGroupName, serverName, advisorName, databaseName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCreateRecommendedActionSession(String resourceGroupName, String serverName, String advisorName, String databaseName, Context context) {
        return this.beginCreateRecommendedActionSessionAsync(resourceGroupName, serverName, advisorName, databaseName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> createRecommendedActionSessionAsync(String resourceGroupName, String serverName, String advisorName, String databaseName) {
        return this.beginCreateRecommendedActionSessionAsync(resourceGroupName, serverName, advisorName, databaseName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> createRecommendedActionSessionAsync(String resourceGroupName, String serverName, String advisorName, String databaseName, Context context) {
        return this.beginCreateRecommendedActionSessionAsync(resourceGroupName, serverName, advisorName, databaseName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createRecommendedActionSession(String resourceGroupName, String serverName, String advisorName, String databaseName) {
        this.createRecommendedActionSessionAsync(resourceGroupName, serverName, advisorName, databaseName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createRecommendedActionSession(String resourceGroupName, String serverName, String advisorName, String databaseName, Context context) {
        this.createRecommendedActionSessionAsync(resourceGroupName, serverName, advisorName, databaseName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MySqlManagementClien")
    private static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/resetQueryPerformanceInsightData")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QueryPerformanceInsightResetDataResultInner>> resetQueryPerformanceInsightData(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/servers/{serverName}/advisors/{advisorName}/createRecommendedActionSession")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createRecommendedActionSession(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="advisorName") String var6, @QueryParam(value="databaseName") String var7, Context var8);
    }
}

