/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.RecommendedActionsClient;
import com.azure.resourcemanager.mysql.fluent.models.RecommendationActionInner;
import com.azure.resourcemanager.mysql.implementation.RecommendationActionImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.RecommendationAction;
import com.azure.resourcemanager.mysql.models.RecommendedActions;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class RecommendedActionsImpl
implements RecommendedActions {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RecommendedActionsImpl.class);
    private final RecommendedActionsClient innerClient;
    private final MySqlManager serviceManager;

    public RecommendedActionsImpl(RecommendedActionsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public RecommendationAction get(String resourceGroupName, String serverName, String advisorName, String recommendedActionName) {
        RecommendationActionInner inner = this.serviceClient().get(resourceGroupName, serverName, advisorName, recommendedActionName);
        if (inner != null) {
            return new RecommendationActionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RecommendationAction> getWithResponse(String resourceGroupName, String serverName, String advisorName, String recommendedActionName, Context context) {
        Response<RecommendationActionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, advisorName, recommendedActionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RecommendationActionImpl((RecommendationActionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<RecommendationAction> listByServer(String resourceGroupName, String serverName, String advisorName) {
        PagedIterable<RecommendationActionInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, advisorName);
        return Utils.mapPage(inner, inner1 -> new RecommendationActionImpl((RecommendationActionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RecommendationAction> listByServer(String resourceGroupName, String serverName, String advisorName, String sessionId, Context context) {
        PagedIterable<RecommendationActionInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, advisorName, sessionId, context);
        return Utils.mapPage(inner, inner1 -> new RecommendationActionImpl((RecommendationActionInner)((Object)inner1), this.manager()));
    }

    private RecommendedActionsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

