/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.MongoIndex;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class MongoDBCollectionResource {
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="shardKey")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> shardKey;
    @JsonProperty(value="indexes")
    private List<MongoIndex> indexes;
    @JsonProperty(value="analyticalStorageTtl")
    private Integer analyticalStorageTtl;
    @JsonProperty(value="restoreParameters")
    private ResourceRestoreParameters restoreParameters;
    @JsonProperty(value="createMode")
    private CreateMode createMode;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDBCollectionResource.class);

    public String id() {
        return this.id;
    }

    public MongoDBCollectionResource withId(String id) {
        this.id = id;
        return this;
    }

    public Map<String, String> shardKey() {
        return this.shardKey;
    }

    public MongoDBCollectionResource withShardKey(Map<String, String> shardKey) {
        this.shardKey = shardKey;
        return this;
    }

    public List<MongoIndex> indexes() {
        return this.indexes;
    }

    public MongoDBCollectionResource withIndexes(List<MongoIndex> indexes) {
        this.indexes = indexes;
        return this;
    }

    public Integer analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    public MongoDBCollectionResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public MongoDBCollectionResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public MongoDBCollectionResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model MongoDBCollectionResource"));
        }
        if (this.indexes() != null) {
            this.indexes().forEach(e -> e.validate());
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }
}

