/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.json.reader;

import com.dbeaver.jdbc.files.json.JsonNode;
import com.google.gson.JsonParser;
import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.ArrayList;

public final class Utils {
    private Utils() {
    }

    static JsonNode<?>[] parseObject(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.END_OBJECT) {
            jsonReader.endObject();
            return null;
        }
        jsonReader.beginObject();
        ArrayList<JsonNode<Object>> row = new ArrayList<JsonNode<Object>>();
        while (jsonReader.peek() != JsonToken.END_OBJECT) {
            row.add(new JsonNode<Object>(jsonReader.nextName(), Utils.parseValue(jsonReader)));
        }
        jsonReader.endObject();
        return row.toArray(new JsonNode[0]);
    }

    static Object parseValue(JsonReader jsonReader) throws IOException {
        JsonToken token = jsonReader.peek();
        if (token == JsonToken.BOOLEAN) {
            return jsonReader.nextBoolean();
        }
        if (token == JsonToken.NUMBER) {
            return ToNumberPolicy.LONG_OR_DOUBLE.readNumber(jsonReader);
        }
        if (token == JsonToken.STRING) {
            return jsonReader.nextString();
        }
        if (token == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return JsonParser.parseReader((JsonReader)jsonReader).toString();
    }
}

