/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.json.reader;

import com.dbeaver.jdbc.files.FFFileReader;
import com.dbeaver.jdbc.files.json.JsonNode;
import com.dbeaver.jdbc.files.json.reader.Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class JsonCompositeFormatRider
implements FFFileReader<JsonNode<?>> {
    @NotNull
    private final JsonReader jsonReader;
    private String currentTable;

    public JsonCompositeFormatRider(@NotNull JsonReader jsonReader) {
        this.jsonReader = jsonReader;
    }

    public boolean openNextTable() throws IOException {
        if (this.jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
            this.jsonReader.beginObject();
        }
        if (this.jsonReader.peek() == JsonToken.NAME) {
            this.currentTable = this.jsonReader.nextName();
            return true;
        }
        this.currentTable = null;
        return false;
    }

    @Nullable
    public String getCurrentTable() {
        return this.currentTable;
    }

    @Nullable
    public JsonNode<?>[] readRow() throws IOException {
        if (this.jsonReader.peek() == JsonToken.END_ARRAY) {
            this.jsonReader.endArray();
            return null;
        }
        if (this.jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
            this.jsonReader.beginArray();
        }
        return Utils.parseObject(this.jsonReader);
    }

    public void close() throws IOException {
        this.jsonReader.close();
    }
}

