/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.dataset;

import com.dbeaver.model.dataset.DBDDataSetQuery;
import com.dbeaver.model.dataset.storage.DatasetStorage;
import com.dbeaver.ui.editors.dataset.DataSetEditor;
import com.dbeaver.ui.editors.dataset.resources.DBNDataSet;
import com.dbeaver.ui.editors.dataset.resources.DBNDataSetFolder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;

public class DatasetHandlerImpl
extends AbstractResourceHandler {
    private static final Log log = Log.getLog(DatasetHandlerImpl.class);

    public int getFeatures(IResource resource) {
        if (resource instanceof IFile) {
            return 11;
        }
        return super.getFeatures(resource);
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) {
        if (resource instanceof IFile) {
            return new DBNDataSet(parentNode, resource, (DBPResourceHandler)this);
        }
        return new DBNDataSetFolder(parentNode, resource, (DBPResourceHandler)this);
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "dataset folder";
        }
        return "dataset";
    }

    /*
     * WARNING - void declaration
     */
    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        void file;
        if (!(resource instanceof IFile)) {
            super.openResource(resource);
            return;
        }
        IFile iFile = (IFile)resource;
        FileEditorInput input = new FileEditorInput((IFile)file);
        int matchFlags = 5;
        UIUtils.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, DataSetEditor.class.getName(), true, matchFlags);
    }

    @Nullable
    public List<DBPDataSourceContainer> getAssociatedDataSources(DBNResource resource) {
        IResource iResource = (IResource)resource.getAdapter(IResource.class);
        if (iResource instanceof IFile) {
            IFile file = (IFile)iResource;
            try {
                DatasetStorage storage = new DatasetStorage(file.getName(), file.readAllBytes(), resource.getOwnerProject().getDataSourceRegistry());
                ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
                for (DBDDataSetQuery dsq : storage.getDataSet().getQueries()) {
                    DBPDataSourceContainer ds = dsq.getDataSourceContainer();
                    if (ds == null || result.contains(ds)) continue;
                    result.add(ds);
                }
                return result;
            }
            catch (Exception e) {
                log.debug((Object)("Error reading dataset storage: " + e.getMessage()));
            }
        }
        return null;
    }
}

