/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.rag.storage;

import com.dbeaver.model.ai.rag.storage.RAGDatabase;
import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaVersionManager;
import org.jkiss.utils.CommonUtils;

public class RAGSchemaVersionManager
implements SQLSchemaVersionManager {
    public int getCurrentSchemaVersion(DBRProgressMonitor monitor, Connection connection, String schemaName) {
        try {
            Object version = JDBCUtils.executeQuery((Connection)connection, (String)"SELECT VERSION FROM {table_prefix}AI_DB_INFO", (Object[])new Object[0]);
            return CommonUtils.toInt((Object)version);
        }
        catch (SQLException sQLException) {
            return -1;
        }
    }

    public int getLatestSchemaVersion() {
        return RAGDatabase.SQL_SCHEMA_CONFIG.getSchemaVersionActual();
    }

    public void updateCurrentSchemaVersion(DBRProgressMonitor monitor, @NotNull Connection connection, @NotNull String schemaName, int version) throws SQLException {
        int updateCount = JDBCUtils.executeUpdate((Connection)connection, (String)"UPDATE {table_prefix}AI_DB_INFO SET VERSION=?,UPDATE_TIME=CURRENT_TIMESTAMP", (Object[])new Object[]{version});
        if (updateCount <= 0) {
            JDBCUtils.executeSQL((Connection)connection, (String)"INSERT INTO {table_prefix}AI_DB_INFO (VERSION,UPDATE_TIME) VALUES(?,CURRENT_TIMESTAMP)", (Object[])new Object[]{version});
        }
    }
}

