/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui;

import com.dbeaver.ee.qm.db.impl.EmbeddedDatabase;
import com.dbeaver.ee.qm.db.impl.QMDBModel;
import com.dbeaver.ee.qmdb.ui.QMDBUIMessages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class QMDBPreferencePage
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(QMDBPreferencePage.class);
    public static final String PAGE_ID = "com.dbeaver.ee.qmdb.persistence";
    private IAdaptable element;
    private Text daysToKeepHistoryText;
    private Button cleanupOldRecordsCheck;

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        final EmbeddedDatabase database = DBWorkbench.getPlatform().getApplication().isPrimaryInstance() && !DBWorkbench.isDistributed() ? QMDBModel.getInstance().getEmbeddedDatabase() : null;
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group infoGroup = UIUtils.createControlGroup((Composite)composite, (String)QMDBUIMessages.preference_page_group_database, (int)2, (int)768, (int)0);
        UIUtils.createLabelText((Composite)infoGroup, (String)QMDBUIMessages.preference_page_label_text_database_path, (String)(database == null ? "N/A" : database.getDatabasePath().toAbsolutePath().toString()), (int)2056, (Object)new GridData(768));
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)"Settings", (int)2, (int)768, (int)0);
        this.cleanupOldRecordsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)"Cleanup old records", (String)"Delete records older than number of specified days", (boolean)preferenceStore.getBoolean("qmdb.autoCleanup"), (int)2);
        this.cleanupOldRecordsCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            this.daysToKeepHistoryText.setEnabled(this.cleanupOldRecordsCheck.getSelection());
            if (this.cleanupOldRecordsCheck.getSelection() && CommonUtils.toInt((Object)this.daysToKeepHistoryText.getText()) <= 0) {
                this.daysToKeepHistoryText.setText("90");
            }
        }));
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)composite) * 10;
        this.daysToKeepHistoryText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Days to keep history", (String)String.valueOf(preferenceStore.getInt("qmdb.maxStoreHistoryDays")), (int)2048, (Object)gd);
        this.cleanupOldRecordsCheck.setSelection(preferenceStore.getBoolean("qmdb.autoCleanup"));
        this.daysToKeepHistoryText.setSelection(preferenceStore.getInt("qmdb.maxStoreHistoryDays"));
        this.daysToKeepHistoryText.setEnabled(this.cleanupOldRecordsCheck.getSelection());
        Group buttonsGroup = UIUtils.createControlGroup((Composite)composite, (String)"Maintenance", (int)4, (int)32, (int)-1);
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_backup_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.backupDatabase(database);
            }
        }).setEnabled(database != null);
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_repair_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.repairDatabase(database);
            }
        }).setEnabled(database != null);
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_compact_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.compactDatabase(database);
            }
        }).setEnabled(database != null);
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)QMDBUIMessages.preference_page_push_button_clean_database, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QMDBPreferencePage.this.cleanDatabase(database);
            }
        }).setEnabled(database != null);
        UIUtils.createInfoLabel((Composite)parent, (String)QMDBUIMessages.preference_page_info_label_h2_embedded_database);
        return composite;
    }

    private void backupDatabase(EmbeddedDatabase database) {
        File file = DialogUtils.selectFileForSave((Shell)this.getShell(), (String)"QMDB-backup.zip");
        if (file != null) {
            try {
                UIUtils.runInProgressDialog(monitor -> {
                    monitor.beginTask("Backup QMDB database", 1);
                    try {
                        monitor.subTask(file.getAbsolutePath());
                        database.backupDatabase(file.toPath());
                        UIUtils.showMessageBox(null, (String)"Backup", (String)"Backup finished", (int)2);
                    }
                    catch (DBException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    monitor.done();
                });
            }
            catch (InvocationTargetException e1) {
                DBWorkbench.getPlatformUI().showError("QMDB backup", "Error making QMDB backup", (Throwable)e1);
            }
        }
    }

    private void repairDatabase(EmbeddedDatabase database) {
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Repair database", (String)"Database repair may corrupt it. You may loose all query history. Do it after database backup.\nAre you sure you want to proceed with database repair?")) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                monitor.beginTask("Repair QMDB database", 7);
                try {
                    monitor.subTask("Stop QMDB");
                    if (database.isRunning()) {
                        database.stop();
                    }
                    monitor.worked(1);
                    monitor.subTask("Dump SQL into " + database.getDatabasePath().toAbsolutePath().toString());
                    Path sqlDumpFile = database.dumpDatabaseToSQL();
                    monitor.worked(1);
                    monitor.subTask("Delete old QMDB files");
                    database.deleteDatabaseFiles();
                    monitor.worked(1);
                    monitor.subTask("Start QMDB");
                    database.start();
                    monitor.worked(1);
                    monitor.subTask("Restore from backup " + String.valueOf(sqlDumpFile.toAbsolutePath()));
                    database.restoreFromSQL(sqlDumpFile);
                    monitor.worked(1);
                    monitor.subTask("Delete backup file");
                    try {
                        Files.delete(sqlDumpFile);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error deleting dump file", (Throwable)e);
                    }
                    monitor.worked(1);
                    try {
                        monitor.subTask("Validate schema");
                        QMDBModel.getInstance().initializeSchema();
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Invalid schema", "Cannot initialize QMDB schema", (Throwable)e);
                    }
                    UIUtils.showMessageBox(null, (String)"Repair", (String)"Repair finished", (int)2);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("QMDB repair", "Error repairing QMDB database", (Throwable)e1);
        }
    }

    private void compactDatabase(EmbeddedDatabase database) {
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Compact database", (String)"Database compact may corrupt it. You may loose all query history. Do it after database backup.\nAre you sure you want to proceed with database compact?")) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                Path backupFile = database.getDatabasePath().getParent().resolve("qmdb-backup-auto.zip");
                if (Files.exists(backupFile, new LinkOption[0])) {
                    try {
                        Files.delete(backupFile);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error deleting backup file " + String.valueOf(backupFile)), (Throwable)e);
                    }
                }
                monitor.beginTask("Compact QMDB database", 6);
                try {
                    monitor.subTask("Make backup to " + String.valueOf(backupFile.toAbsolutePath()));
                    database.backupDatabase(backupFile);
                    monitor.worked(1);
                    monitor.subTask("Stop QMDB");
                    database.stop();
                    monitor.worked(1);
                    monitor.subTask("Delete old QMDB files");
                    ContentUtils.deleteFileRecursive((File)database.getDatabasePath().toFile());
                    monitor.worked(1);
                    monitor.subTask("Restore from backup " + String.valueOf(backupFile.toAbsolutePath()));
                    database.restoreDatabase(backupFile);
                    monitor.worked(1);
                    monitor.subTask("Start QMDB");
                    database.start();
                    monitor.worked(1);
                    monitor.subTask("Delete backup file");
                    try {
                        Files.delete(backupFile);
                    }
                    catch (IOException e) {
                        log.error((Object)("Error deleting backup file " + String.valueOf(backupFile)), (Throwable)e);
                    }
                    monitor.worked(1);
                    UIUtils.showMessageBox(null, (String)"Compact", (String)"Compact finished", (int)2);
                }
                catch (DBException e1) {
                    throw new InvocationTargetException(e1);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("QMDB compact", "Error compact QMDB database", (Throwable)e1);
        }
    }

    private void cleanDatabase(EmbeddedDatabase database) {
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Clean database", (String)"Database clean will erase all SQL queries.\nAre you sure you want to proceed with the clean?")) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                monitor.beginTask("Compact QMDB database", 3);
                monitor.subTask("Stop QMDB");
                QMDBModel.shutdown();
                monitor.worked(1);
                monitor.subTask("Delete old QMDB files");
                ContentUtils.deleteFileRecursive((File)database.getDatabasePath().toFile());
                monitor.worked(1);
                monitor.subTask("Start QMDB");
                database.start();
                monitor.worked(1);
                UIUtils.showMessageBox(null, (String)"Clean", (String)"Clean finished", (int)2);
                monitor.done();
            });
        }
        catch (InvocationTargetException e1) {
            DBWorkbench.getPlatformUI().showError("QMDB clean", "Error clean QMDB database", (Throwable)e1);
        }
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)"Clean database", (String)"DBeaver must be restarted after the Query Manager has been cleaned up. Do it now?")) {
            PlatformUI.getWorkbench().restart();
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        boolean doCleanup = this.cleanupOldRecordsCheck.getSelection();
        int historyDays = CommonUtils.toInt((Object)this.daysToKeepHistoryText.getText());
        if (doCleanup != preferenceStore.getBoolean("qmdb.autoCleanup") || historyDays != preferenceStore.getInt("qmdb.maxStoreHistoryDays")) {
            if (doCleanup && !UIUtils.confirmAction((Shell)this.getShell(), (String)"Change cleanup settings", (String)"Are you sure?\nEnabling cleanup settings will delete history data in Query Manager database.\nThis change is irreversible.\n\nNote: you need to restart application to reduce database size on the disk")) {
                return false;
            }
            preferenceStore.setValue("qmdb.autoCleanup", doCleanup);
            preferenceStore.setValue("qmdb.maxStoreHistoryDays", historyDays);
            try {
                preferenceStore.save();
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            if (doCleanup) {
                try {
                    UIUtils.runInProgressDialog(monitor -> {
                        monitor.beginTask("Cleanup old records", 1);
                        QMDBModel.getInstance().startCleanupJob(monitor);
                        monitor.done();
                    });
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Cleanup failed", "QMDB database cleanup failed", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }
}

