/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.cyberark;

import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.utils.CommonUtils;

public class CyberArkParametersProviderConfiguration
extends DBPParametersConfiguration {
    @NotNull
    private String baseUrl = "";
    @NotNull
    private String account = "";
    @NotNull
    private String username = "";
    @SecureProperty
    @NotNull
    private String apiKey = "";
    @NotNull
    private String policyBranch = "";
    @Nullable
    private Boolean globalConfiguration = null;
    private boolean trustCertificate;

    public CyberArkParametersProviderConfiguration(@NotNull String configurationId) {
        super("cyberark-parameters-provider", configurationId);
    }

    @Property(required=true, order=1)
    @NotNull
    public String getBaseUrl() {
        return CommonUtils.trim((String)this.baseUrl);
    }

    public void setBaseUrl(@NotNull String baseUrl) {
        this.baseUrl = CommonUtils.trim((String)baseUrl);
    }

    @Property(required=true, order=2)
    @NotNull
    public String getAccount() {
        return CommonUtils.trim((String)this.account);
    }

    public void setAccount(@NotNull String account) {
        this.account = CommonUtils.trim((String)account);
    }

    @Property(required=true, order=3)
    @NotNull
    public String getUsername() {
        return CommonUtils.trim((String)this.username);
    }

    public void setUsername(@NotNull String username) {
        this.username = CommonUtils.trim((String)username);
    }

    @SecureProperty
    @Property(required=true, password=true, order=4)
    @NotNull
    public String getApiKey() {
        return CommonUtils.trim((String)this.apiKey);
    }

    public void setApiKey(@NotNull String apiKey) {
        this.apiKey = CommonUtils.trim((String)apiKey);
    }

    @Property(required=true, order=5)
    @NotNull
    public String getPolicyBranch() {
        return CommonUtils.trim((String)this.policyBranch);
    }

    public void setPolicyBranch(@NotNull String policyBranch) {
        this.policyBranch = CommonUtils.trim((String)policyBranch);
    }

    @Property(order=6)
    public boolean isTrustCertificate() {
        return this.trustCertificate;
    }

    public void setTrustCertificate(boolean trust) {
        this.trustCertificate = trust;
    }

    @Property(order=7, requiredFeatures={"distributed"})
    public boolean isGlobalConfiguration() {
        return this.globalConfiguration == null || this.globalConfiguration != false;
    }

    public void setGlobalConfiguration(boolean globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public boolean valid() {
        return CommonUtils.isNotEmpty((String)this.baseUrl) && CommonUtils.isNotEmpty((String)this.account) && CommonUtils.isNotEmpty((String)this.username) && CommonUtils.isNotEmpty((String)this.apiKey) && CommonUtils.isNotEmpty((String)this.policyBranch) && super.valid();
    }

    @NotNull
    public String getVersion() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            CyberArkParametersProviderConfiguration.feed(md, this.getBaseUrl());
            CyberArkParametersProviderConfiguration.feed(md, this.getAccount());
            CyberArkParametersProviderConfiguration.feed(md, this.getUsername());
            CyberArkParametersProviderConfiguration.feed(md, this.getApiKey());
            CyberArkParametersProviderConfiguration.feed(md, this.getPolicyBranch());
            CyberArkParametersProviderConfiguration.feed(md, Boolean.toString(this.isTrustCertificate()));
            CyberArkParametersProviderConfiguration.feed(md, Boolean.toString(this.isGlobalConfiguration()));
            return HexFormat.of().formatHex(md.digest()).substring(0, 12);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void feed(@NotNull MessageDigest md, @NotNull String value) {
        md.update(value.getBytes(StandardCharsets.UTF_8));
        md.update((byte)0);
    }
}

