/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.EventSubscription;

public class DescribeEventSubscriptionsIterable
implements SdkIterable<DescribeEventSubscriptionsResponse> {
    private final RedshiftClient client;
    private final DescribeEventSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventSubscriptionsIterable(RedshiftClient client, DescribeEventSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEventSubscriptionsResponseFetcher();
    }

    public Iterator<DescribeEventSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventSubscription> eventSubscriptionsList() {
        Function<DescribeEventSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSubscriptionsList() != null) {
                return response.eventSubscriptionsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEventSubscriptionsResponseFetcher
    implements SyncPageFetcher<DescribeEventSubscriptionsResponse> {
        private DescribeEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEventSubscriptionsResponse nextPage(DescribeEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventSubscriptionsIterable.this.client.describeEventSubscriptions(DescribeEventSubscriptionsIterable.this.firstRequest);
            }
            return DescribeEventSubscriptionsIterable.this.client.describeEventSubscriptions((DescribeEventSubscriptionsRequest)((Object)DescribeEventSubscriptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

