/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.ServiceAuthorization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LakeFormationQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LakeFormationQuery> {
    private static final SdkField<String> AUTHORIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Authorization").getter(LakeFormationQuery.getter(LakeFormationQuery::authorizationAsString)).setter(LakeFormationQuery.setter(Builder::authorization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authorization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LakeFormationQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authorization;

    private LakeFormationQuery(BuilderImpl builder) {
        this.authorization = builder.authorization;
    }

    public final ServiceAuthorization authorization() {
        return ServiceAuthorization.fromValue(this.authorization);
    }

    public final String authorizationAsString() {
        return this.authorization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationQuery)) {
            return false;
        }
        LakeFormationQuery other = (LakeFormationQuery)obj;
        return Objects.equals(this.authorizationAsString(), other.authorizationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LakeFormationQuery").add("Authorization", (Object)this.authorizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Authorization": {
                return Optional.ofNullable(clazz.cast(this.authorizationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Authorization", AUTHORIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationQuery, T> g) {
        return obj -> g.apply((LakeFormationQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorization;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationQuery model) {
            this.authorization(model.authorization);
        }

        public final String getAuthorization() {
            return this.authorization;
        }

        public final void setAuthorization(String authorization) {
            this.authorization = authorization;
        }

        @Override
        public final Builder authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        @Override
        public final Builder authorization(ServiceAuthorization authorization) {
            this.authorization(authorization == null ? null : authorization.toString());
            return this;
        }

        public LakeFormationQuery build() {
            return new LakeFormationQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LakeFormationQuery> {
        public Builder authorization(String var1);

        public Builder authorization(ServiceAuthorization var1);
    }
}

