/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.datatype;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.UUIDType;
import liquibase.exception.DatabaseException;
import liquibase.ext.hana.HanaDatabase;

@DataTypeInfo(name="uuid", aliases={"uniqueidentifier", "java.util.UUID"}, minParameters=0, maxParameters=0, priority=5)
public class UUIDTypeHana
extends UUIDType {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof HanaDatabase;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        try {
            if (database.getDatabaseMajorVersion() >= 4) {
                return new DatabaseDataType("NVARCHAR", new Object[]{36});
            }
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Unable to determine the database version.", (Throwable)e);
        }
        return new DatabaseDataType("VARCHAR", new Object[]{36});
    }
}

