/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.datatype;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.ClobType;
import liquibase.exception.DatabaseException;
import liquibase.ext.hana.HanaDatabase;

@DataTypeInfo(name="clob", aliases={"longvarchar", "java.sql.Types.LONGVARCHAR", "java.sql.Types.CLOB"}, minParameters=0, maxParameters=0, priority=5)
public class ClobTypeHana
extends ClobType {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof HanaDatabase;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        try {
            if (database.getDatabaseMajorVersion() >= 4) {
                return new DatabaseDataType("NCLOB");
            }
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Unable to determine the database version.", (Throwable)e);
        }
        return new DatabaseDataType("CLOB");
    }
}

