/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.rm;

import com.dbeaver.model.DBRMController;
import com.dbeaver.model.rm.RMAdminController;
import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.rm.RMClientBase;
import com.dbeaver.remote.client.rm.RMClientConfiguration;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.rm.RMEvent;
import org.jkiss.dbeaver.model.rm.RMEventManager;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectInfo;
import org.jkiss.dbeaver.model.rm.RMResource;

public class RMClient
extends RMClientBase
implements RMAdminController,
RMController,
DBRMController {
    public RMClient(RMClientConfiguration config) {
        super(config);
    }

    @NotNull
    public RMProject[] listAccessibleProjects() throws DBException {
        return (RMProject[])this.executeGetRequestVal("projects", (Type)((Object)RMProject[].class));
    }

    @NotNull
    public RMProject[] listAllSharedProjects() throws DBException {
        return (RMProject[])this.executeGetRequestVal("projects/shared", (Type)((Object)RMProject[].class));
    }

    public RMProject createProject(@NotNull String name, @Nullable String description) throws DBException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("name", name);
        if (description != null) {
            requestParams.put("description", description);
        }
        RMProject project = (RMProject)this.executePutRequestVal(RMClient.buildEndpointUrl((String[])new String[]{"projects", "create"}), requestParams, (Type)((Object)RMProject.class));
        RMEventManager.fireEvent((RMEvent)new RMEvent(RMEvent.Action.PROJECT_ADD, project));
        return project;
    }

    public RMProject updateProject(@NotNull String projectId, @Nullable RMProjectInfo projectInfo) throws DBException {
        return (RMProject)this.executePostRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId}), projectInfo, (Type)((Object)RMProject.class));
    }

    public void deleteProject(@NotNull String projectId) throws DBException {
        this.executeDeleteRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId}), Map.of(), (Type)((Object)Void.class));
    }

    public RMProject getProject(@NotNull String projectId, boolean readResources, boolean readProperties) throws DBException {
        Map<String, Boolean> params = Map.of("readResources", readResources, "readProperties", readProperties);
        return (RMProject)this.executeGetRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId}), params, (Type)((Object)RMProject.class));
    }

    public Object getProjectProperty(@NotNull String projectId, @NotNull String propName) throws DBException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("property", propName);
        return this.executeGetRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "properties"}), requestParams, (Type)((Object)Object.class));
    }

    public void setProjectProperty(@NotNull String projectId, @NotNull String propName, @NotNull Object propValue) throws DBException {
        Map<String, String> requestParams = Map.of("property", propName);
        this.executePutRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "properties"}), requestParams, propValue, (Type)((Object)Void.class));
    }

    public String getProjectsDataSources(@NotNull String projectId, @Nullable String[] dataSourceIds) throws DBException {
        HashMap<String, String[]> requestParams = new HashMap<String, String[]>();
        if (dataSourceIds != null) {
            requestParams.put("dataSourceIds", dataSourceIds);
        }
        return (String)this.executeGetRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "datasources"}), requestParams, (Type)((Object)String.class));
    }

    public void createProjectDataSources(@NotNull String projectId, @NotNull String configuration, @Nullable List<String> dataSourceIds) throws DBException {
        this.executePutRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "datasources"}), dataSourceIds == null ? Map.of() : Map.of("dataSourceIds", dataSourceIds), configuration, BodyConverter.TEXT_PLAIN, (Type)((Object)Void.class));
    }

    public boolean updateProjectDataSources(@NotNull String projectId, @NotNull String configuration, @Nullable List<String> dataSourceIds) throws DBException {
        return (Boolean)this.executePostRequestVal(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "datasources"}), dataSourceIds == null ? Map.of() : Map.of("dataSourceIds", dataSourceIds), configuration, BodyConverter.TEXT_PLAIN, (Type)((Object)Boolean.class));
    }

    public void deleteProjectDataSources(@NotNull String projectId, @NotNull String[] dataSourceIds) throws DBException {
        this.executeDeleteRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "datasources"}), Map.of("dataSourceIds", dataSourceIds), (Type)((Object)Void.class));
    }

    public void createProjectDataSourceFolder(@NotNull String projectId, @NotNull String folderPath) throws DBException {
        Map<String, String> requestParams = Map.of("folderPath", folderPath);
        String url = RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "datasources", "folders"});
        this.executePostRequest(url, requestParams, (Type)((Object)Void.class));
    }

    public void deleteProjectDataSourceFolders(@NotNull String projectId, @NotNull String[] folderPaths, boolean dropContents) throws DBException {
        Map<String, Boolean> requestParams = Map.of("folderPaths", folderPaths, "dropContents", dropContents);
        String url = RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "datasources", "folders"});
        this.executeDeleteRequest(url, requestParams, (Type)((Object)Void.class));
    }

    public void moveProjectDataSourceFolder(@NotNull String projectId, @NotNull String oldPath, @NotNull String newPath) throws DBException {
        Map<String, String> requestParams = Map.of("oldPath", oldPath, "newPath", newPath);
        String url = RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "datasources", "folders"});
        this.executePutRequest(url, requestParams, (Type)((Object)Void.class));
    }

    @NotNull
    public RMResource[] listResources(@NotNull String projectId, @Nullable String folder, @Nullable String nameMask, boolean readProperties, boolean readHistory, boolean recursive) throws DBException {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        if (folder != null) {
            requestParams.put("folder", folder);
        }
        if (nameMask != null) {
            requestParams.put("nameMask", nameMask);
        }
        if (readProperties) {
            requestParams.put("readProperties", readProperties);
        }
        if (readHistory) {
            requestParams.put("readHistory", readHistory);
        }
        if (recursive) {
            requestParams.put("recursive", recursive);
        }
        return (RMResource[])this.executeGetRequestVal(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources", "list"}), requestParams, (Type)((Object)RMResource[].class));
    }

    public String createResource(@NotNull String projectId, @NotNull String resourcePath, boolean isFolder) throws DBException {
        Map<String, Boolean> requestParams = Map.of("resourcePath", resourcePath, "isFolder", isFolder);
        String result = (String)this.executePostRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources"}), requestParams, (Type)((Object)String.class));
        this.fireResourceAddEvent(projectId, resourcePath);
        return result;
    }

    public String moveResource(@NotNull String projectId, @NotNull String oldResourcePath, @NotNull String newResourcePath) throws DBException {
        Map<String, String> requestParams = Map.of("oldResourcePath", oldResourcePath, "newResourcePath", newResourcePath);
        RMEvent event = new RMEvent(RMEvent.Action.RESOURCE_DELETE, this.getRmProject(projectId), oldResourcePath);
        String result = (String)this.executePutRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources", "path"}), requestParams, (Type)((Object)String.class));
        RMEventManager.fireEvent((RMEvent)event);
        this.fireResourceAddEvent(projectId, newResourcePath);
        return result;
    }

    public void deleteResource(@NotNull String projectId, @NotNull String resourcePath, boolean recursive) throws DBException {
        RMEvent event = new RMEvent(RMEvent.Action.RESOURCE_DELETE, this.getRmProject(projectId), resourcePath);
        Map<String, Boolean> requestParams = Map.of("resourcePath", resourcePath, "recursive", recursive);
        this.executeDeleteRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources"}), requestParams, (Type)((Object)Void.class));
        RMEventManager.fireEvent((RMEvent)event);
    }

    public RMResource[] getResourcePath(@NotNull String projectId, @NotNull String resourcePath) throws DBException {
        Map<String, String> requestParams = Map.of("resourcePath", resourcePath);
        return (RMResource[])this.executeGetRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources", "path"}), requestParams, (Type)((Object)RMResource[].class));
    }

    @Nullable
    public RMResource getResource(@NotNull String projectId, @NotNull String resourcePath) throws DBException {
        Map<String, String> requestParams = Map.of("resourcePath", resourcePath);
        return (RMResource)this.executeGetRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources", "meta"}), requestParams, (Type)((Object)RMResource.class));
    }

    @NotNull
    public byte[] getResourceContents(@NotNull String projectId, @NotNull String resourcePath) throws DBException {
        Map<String, String> requestParams = Map.of("resourcePath", resourcePath);
        String result = (String)this.executeGetRequestVal(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources"}), requestParams, (Type)((Object)String.class));
        return result.getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    public String setResourceContents(@NotNull String projectId, @NotNull String resourcePath, @NotNull byte[] data, boolean forceOverwrite) throws DBException {
        Map<String, Boolean> requestParams = Map.of("resourcePath", resourcePath, "forceOverwrite", forceOverwrite);
        String content = (String)this.executePutRequestVal(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources"}), requestParams, data, BodyConverter.OCTET_STREAM, (Type)((Object)String.class));
        if (!forceOverwrite) {
            this.fireResourceAddEvent(projectId, resourcePath);
        }
        return content;
    }

    private void fireResourceAddEvent(@NotNull String projectId, @NotNull String resourcePath) {
        RMEvent event = new RMEvent(RMEvent.Action.RESOURCE_ADD, this.getRmProject(projectId), resourcePath);
        RMEventManager.fireEvent((RMEvent)event);
    }

    @NotNull
    private RMProject getRmProject(String projectId) {
        RMProject project = new RMProject();
        project.setId(projectId);
        return project;
    }

    @NotNull
    public String setResourceProperty(@NotNull String projectId, @NotNull String resourcePath, @NotNull String propertyName, @Nullable Object propertyValue) throws DBException {
        Map<String, String> params = Map.of("resourcePath", resourcePath, "propertyName", propertyName);
        return (String)this.executePutRequestVal(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources/properties"}), params, propertyValue, (Type)((Object)String.class));
    }

    @NotNull
    public String setResourceProperties(@NotNull String projectId, @NotNull String resourcePath, @NotNull Map<String, Object> properties) throws DBException {
        Map<String, String> params = Map.of("resourcePath", resourcePath);
        return (String)this.executePutRequestVal(RMClient.buildEndpointUrl((String[])new String[]{"projects", projectId, "resources/allPoperties"}), params, properties, (Type)((Object)String.class));
    }

    public void saveProjectConfiguration(@NotNull String projectId, @NotNull String configurationPath, @NotNull String configuration) throws DBException {
        Map<String, String> params = Map.of("configurationPath", configurationPath);
        this.executePostRequest(RMClient.buildEndpointUrl((String[])new String[]{"admin/projects", projectId, "configuration"}), params, configuration, BodyConverter.TEXT_PLAIN, (Type)((Object)Void.class));
    }

    @Nullable
    public String readProjectConfiguration(@NotNull String projectId, @NotNull String configurationPath) throws DBException {
        Map<String, String> params = Map.of("configurationPath", configurationPath);
        return (String)this.executeGetRequest(RMClient.buildEndpointUrl((String[])new String[]{"admin/projects", projectId, "configuration"}), params, BodyConverter.TEXT_PLAIN, (Type)((Object)String.class));
    }

    public String backupProject(@NotNull String projectId) throws DBException {
        return (String)this.executePostRequest(RMClient.buildEndpointUrl((String[])new String[]{projectId, "backup"}), Map.of(), (Type)((Object)String.class));
    }

    public void restoreBackup(@NotNull String projectId, @NotNull String backupId) throws DBException {
        this.executePostRequest(RMClient.buildEndpointUrl((String[])new String[]{projectId, "backup", backupId}), Map.of(), (Type)((Object)Void.class));
    }

    public String ping() throws DBException {
        return (String)this.executeGetRequest(RMClient.buildEndpointUrl((String[])new String[]{"projects", "ping"}), (Type)((Object)String.class));
    }
}

