/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.rm;

import com.dbeaver.model.auth.SMClientUtils;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.rm.DBFileControllerClient;
import com.dbeaver.remote.client.rm.RMClientBase;
import com.dbeaver.remote.client.rm.RMClientConfiguration;
import com.dbeaver.remote.client.rm.RemoteRMUtils;
import java.lang.reflect.Type;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBFileController;
import org.jkiss.dbeaver.model.auth.SMCredentials;

public class FileControllerClient
extends RMClientBase
implements DBFileController,
DBFileControllerClient {
    @Nullable
    private final String encryptKey;

    public FileControllerClient(RMClientConfiguration config) {
        super(config);
        SMCredentials activeCredentials = config.getCredentialsProvider().getActiveUserCredentials();
        this.encryptKey = activeCredentials != null ? config.getCredentialsProvider().getActiveUserCredentials().getSmSessionId() : null;
    }

    public byte[] loadFileData(@NotNull String fileType, @NotNull String filePath) throws DBException {
        Map<String, String> params = Map.of("filePath", filePath);
        boolean encrypted = this.isEncryptedMode();
        String endpointUrl = encrypted ? FileControllerClient.buildEndpointUrl((String[])new String[]{"data-files", "content", fileType, "encrypted"}) : FileControllerClient.buildEndpointUrl((String[])new String[]{"data-files", "content", fileType});
        byte[] fileData = (byte[])this.executeGetRequest(endpointUrl, params, BodyConverter.OCTET_STREAM, (Type)((Object)byte[].class));
        return encrypted ? RemoteRMUtils.xor(fileData, this.encryptKey) : fileData;
    }

    public void saveFileData(@NotNull String fileType, @NotNull String filePath, byte[] fileData) throws DBException {
        byte[] dataToSend;
        String endpointUrl;
        boolean encrypted = this.isEncryptedMode();
        if (encrypted) {
            endpointUrl = FileControllerClient.buildEndpointUrl((String[])new String[]{"data-files", "content", fileType, "encrypted"});
            dataToSend = RemoteRMUtils.xor(fileData, this.encryptKey);
        } else {
            endpointUrl = FileControllerClient.buildEndpointUrl((String[])new String[]{"data-files", "content", fileType});
            dataToSend = fileData;
        }
        Map<String, String> params = Map.of("filePath", filePath);
        this.executePutRequest(endpointUrl, params, dataToSend, BodyConverter.OCTET_STREAM, (Type)((Object)byte[].class));
    }

    private boolean isEncryptedMode() {
        return this.encryptKey != null && SMClientUtils.isServerLegacy((SMServerAPI)this.serverAPI, (String)"25.0.3");
    }

    public String[] listFiles(@NotNull String fileType, @NotNull String filePath) throws DBException {
        Map<String, String> params = Map.of("filePath", filePath);
        return (String[])this.executeGetRequest(FileControllerClient.buildEndpointUrl((String[])new String[]{"data-files", "list", fileType}), params, (Type)((Object)String[].class));
    }

    public void deleteFile(@NotNull String fileType, @NotNull String filePath, boolean recursive) throws DBException {
        Map<String, Boolean> params = Map.of("filePath", filePath, "recursive", recursive);
        this.executeDeleteRequest(FileControllerClient.buildEndpointUrl((String[])new String[]{"data-files", "content", fileType}), params, (Type)((Object)String.class));
    }
}

