/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.ortho;

import com.dbeaver.ui.editors.erd.ortho.OrthoPath;
import com.dbeaver.ui.editors.erd.ortho.RouteRectangle;
import com.dbeaver.ui.editors.erd.ortho.RouteSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoutePoint
extends Point {
    private static final long serialVersionUID = 1L;
    static final int NOT_SET = 0;
    static final int INNIE = 1;
    static final int OUTIE = 2;
    private List<Object> neighbors;
    private boolean isPermanent = false;
    private RoutePoint label;
    private double cost = 0.0;
    private int nearestObstacle = 0;
    private double offset = 0.0;
    private int type = 0;
    int count = 0;
    int totalCount = 0;
    private RouteRectangle obs;
    private List<OrthoPath> paths;
    private boolean nearestObstacleChecked = false;
    private Map<OrthoPath, Double> cachedCosines;
    private int positionOnObstacle = -1;
    private int origX;
    private int origY;

    RoutePoint(int x, int y, RouteRectangle obs) {
        super(x, y);
        this.origX = x;
        this.origY = y;
        this.obs = obs;
    }

    RoutePoint(Point p, RouteRectangle obs) {
        this(p.x, p.y, obs);
    }

    public void addPath(OrthoPath path, RouteSegment start, RouteSegment end) {
        if (this.paths == null) {
            this.paths = new ArrayList<OrthoPath>();
            this.cachedCosines = new HashMap<OrthoPath, Double>();
        }
        if (!this.paths.contains(path)) {
            this.paths.add(path);
        }
        this.cachedCosines.put(path, start.cosine(end));
    }

    public Point bend(int modifier) {
        Point point = new Point(this.x, this.y);
        point.y = (this.positionOnObstacle & 1) > 0 ? (int)((double)point.y - (double)modifier * this.offset) : (int)((double)point.y + (double)modifier * this.offset);
        point.x = (this.positionOnObstacle & 0x10) > 0 ? (int)((double)point.x + (double)modifier * this.offset) : (int)((double)point.x - (double)modifier * this.offset);
        return point;
    }

    public void fullReset() {
        this.totalCount = 0;
        this.type = 0;
        this.count = 0;
        this.cost = 0.0;
        this.offset = this.getSpacing();
        this.nearestObstacle = 0;
        this.setLabel(null);
        this.nearestObstacleChecked = false;
        this.setPermanent(false);
        if (this.neighbors != null) {
            this.neighbors.clear();
        }
        if (this.cachedCosines != null) {
            this.cachedCosines.clear();
        }
        if (this.paths != null) {
            this.paths.clear();
        }
    }

    public Rectangle getDeformedRectangle(int extraOffset) {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        if ((this.positionOnObstacle & 1) > 0) {
            rect.y = this.y - extraOffset;
            rect.height = this.origY - this.y + extraOffset;
        } else {
            rect.y = this.origY;
            rect.height = this.y - this.origY + extraOffset;
        }
        if ((this.positionOnObstacle & 0x10) > 0) {
            rect.x = this.origX;
            rect.width = this.x - this.origX + extraOffset;
        } else {
            rect.x = this.x - extraOffset;
            rect.width = this.origX - this.x + extraOffset;
        }
        return rect;
    }

    private int getSpacing() {
        if (this.obs == null) {
            return 0;
        }
        return 1;
    }

    public void grow() {
        int modifier = this.nearestObstacle == 0 ? this.totalCount * this.getSpacing() : this.nearestObstacle / 2 - 1;
        this.y = (this.positionOnObstacle & 1) > 0 ? (this.y -= modifier) : (this.y += modifier);
        this.x = (this.positionOnObstacle & 0x10) > 0 ? (this.x += modifier) : (this.x -= modifier);
    }

    public void shrink() {
        this.x = this.origX;
        this.y = this.origY;
    }

    public void updateOffset() {
        if (this.nearestObstacle != 0) {
            this.offset = (this.nearestObstacle / 2 - 1) / this.totalCount;
        }
    }

    public String toString() {
        return "V(" + this.origX + ", " + this.origY + ")";
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public void setPermanent(boolean isPermanent) {
        this.isPermanent = isPermanent;
    }

    public RoutePoint getLabel() {
        return this.label;
    }

    public void setLabel(RoutePoint label) {
        this.label = label;
    }

    public double getCost() {
        return this.cost;
    }

    public boolean isNearestObstacleChecked() {
        return this.nearestObstacleChecked;
    }

    public void setNearestObstacleChecked(boolean flag) {
        this.nearestObstacleChecked = flag;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getPositionOnObstacle() {
        return this.positionOnObstacle;
    }

    public void setPositionOnObstacle(int position) {
        this.positionOnObstacle = position;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public List<Object> getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(ArrayList<Object> arrayList) {
        this.neighbors = arrayList;
    }

    public RouteRectangle getObs() {
        return this.obs;
    }

    public int getNearestObstacle() {
        return this.nearestObstacle;
    }

    public void setNearestObstacle(int nearestObstacle) {
        this.nearestObstacle = nearestObstacle;
    }

    public Map<OrthoPath, Double> getCachedCosines() {
        return this.cachedCosines;
    }

    public void setCachedCosines(Map<OrthoPath, Double> cachedCosines) {
        this.cachedCosines = cachedCosines;
    }

    public List<OrthoPath> getPaths() {
        return this.paths;
    }

    public void setPaths(List<OrthoPath> paths) {
        this.paths = paths;
    }
}

