/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.erd.ortho;

import com.dbeaver.ui.editors.erd.ortho.RouteLine;
import com.dbeaver.ui.editors.erd.ortho.RoutePoint;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class OrthoPath {
    public Connection connection;
    public boolean isDirty = true;
    PointList bendpoints;
    PointList points = new PointList();
    private RoutePoint start;
    private RoutePoint end;
    private OrthoPath subPath;
    private List<RouteLine> traceLines;

    public OrthoPath() {
    }

    public OrthoPath(Connection data) {
        this();
        this.connection = data;
    }

    public OrthoPath(Point start, Point end) {
        this(new RoutePoint(start, null), new RoutePoint(end, null));
    }

    OrthoPath(RoutePoint start, RoutePoint end) {
        this();
        this.start = start;
        this.end = end;
    }

    void fullReset() {
        this.resetPartial();
    }

    public PointList getBendPoints() {
        return this.bendpoints;
    }

    public void setBendPoints(PointList bendPoints) {
        this.bendpoints = bendPoints;
        this.isDirty = true;
    }

    public Point getEndPoint() {
        return this.end;
    }

    public void setEndPoint(Point end) {
        if (end.equals((Object)this.end)) {
            return;
        }
        this.end = new RoutePoint(end, null);
        this.isDirty = true;
    }

    public PointList getPoints() {
        return this.points;
    }

    public void setPoints(PointList resultPointList) {
        this.points.removeAllPoints();
        this.points.addAll(resultPointList);
    }

    public Point getStartPoint() {
        return this.start;
    }

    public void setStartPoint(Point start) {
        if (start.equals((Object)this.start)) {
            return;
        }
        this.start = new RoutePoint(start, null);
        this.isDirty = true;
    }

    void reconnectSubPaths() {
        if (this.subPath != null) {
            this.subPath.reconnectSubPaths();
            this.subPath.points.removePoint(0);
            this.points.removePoint(this.points.size() - 1);
            this.points.addAll(this.subPath.points);
            this.end = this.subPath.end;
            this.subPath = null;
        }
    }

    void resetPartial() {
        this.subPath = null;
        this.isDirty = false;
        this.points.removeAllPoints();
    }

    public RoutePoint getStart() {
        return this.start;
    }

    public RoutePoint getEnd() {
        return this.end;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setTraceLine(RouteLine trgDistanceLine) {
        if (this.traceLines == null) {
            this.traceLines = new ArrayList<RouteLine>();
        }
        this.traceLines.add(trgDistanceLine);
    }

    public List<RouteLine> getTraceLines() {
        return this.traceLines;
    }

    public void removeTraceLines() {
        if (this.traceLines != null) {
            this.traceLines.clear();
        }
    }
}

