/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.engine.openai;

import com.dbeaver.model.ai.engine.openai.OpenAIPropertiesPro;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIProperties;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.ui.ai.engine.openai.OpenAiConfigurator;
import org.jkiss.dbeaver.ui.ai.model.ModelSelectorField;

public class OpenAIProConfigurator
extends OpenAiConfigurator<AIEngineDescriptor, OpenAIPropertiesPro> {
    private ModelSelectorField transcribeModelSelectorField;

    protected void createAdditionalSettings(@NotNull Composite parent) {
        super.createAdditionalSettings(parent);
    }

    protected void createModelParameters(@NotNull Composite parent) {
        super.createModelParameters(parent);
        this.transcribeModelSelectorField = ModelSelectorField.builder().withParent(parent).withGridData(new GridData(768)).withModelLabel("Transcript model").withModelListSupplier((monitor, forceRefresh) -> ((List)this.modelsCache.get(monitor, forceRefresh)).stream().filter(model -> model.features().contains(AIModelFeature.SPEECH_TO_TEXT)).map(AIModel::name).toList()).build();
    }

    public void loadSettings(@NotNull OpenAIPropertiesPro configuration) {
        super.loadSettings((OpenAIProperties)configuration);
        this.transcribeModelSelectorField.setSelectedModel(configuration.getTranscribeModel());
        this.transcribeModelSelectorField.refreshModelListSilently(false);
    }

    public void saveSettings(@NotNull OpenAIPropertiesPro configuration) {
        super.saveSettings((OpenAIProperties)configuration);
        configuration.setTranscribeModel(this.transcribeModelSelectorField.getSelectedModel());
    }

    public void resetSettings(@NotNull OpenAIPropertiesPro openAIPropertiesLegacyAISettings) {
        super.resetSettings((OpenAIProperties)openAIPropertiesLegacyAISettings);
    }

    public Optional<AIEngineProperties> getCurrentProperties() {
        OpenAIPropertiesPro configuration = new OpenAIPropertiesPro();
        this.saveSettings(configuration);
        return Optional.of(configuration);
    }
}

