/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.Partition;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.topology.TopologyHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

@Deprecated
@JsonIgnoreProperties(ignoreUnknown=true)
public class PartitionInfo {
    private final int numberOfReplicas;
    private final String[] partitionHosts;
    private final List<Partition> partitions;
    private final List<Partition> forwardPartitions;
    private final boolean tainted;

    PartitionInfo(@JsonProperty(value="numReplicas") int numberOfReplicas, @JsonProperty(value="serverList") List<String> partitionHosts, @JsonProperty(value="vBucketMap") List<List<Short>> partitions, @JsonProperty(value="vBucketMapForward") List<List<Short>> forwardPartitions) {
        this.numberOfReplicas = numberOfReplicas;
        this.partitionHosts = partitionHosts.toArray(new String[partitionHosts.size()]);
        this.partitions = PartitionInfo.fromPartitionList(partitions);
        if (forwardPartitions != null && !forwardPartitions.isEmpty()) {
            this.forwardPartitions = PartitionInfo.fromPartitionList(forwardPartitions);
            this.tainted = true;
        } else {
            this.forwardPartitions = null;
            this.tainted = false;
        }
    }

    public boolean hasFastForwardMap() {
        return this.forwardPartitions != null;
    }

    public int numberOfReplicas() {
        return this.numberOfReplicas;
    }

    public String[] partitionHosts() {
        return this.partitionHosts;
    }

    public List<Partition> partitions() {
        return this.partitions;
    }

    public List<Partition> forwardPartitions() {
        return this.forwardPartitions;
    }

    public boolean tainted() {
        return this.tainted;
    }

    private static List<Partition> fromPartitionList(List<List<Short>> input) {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (input == null) {
            return partitions;
        }
        for (List<Short> partition : input) {
            short active = partition.remove(0);
            short[] replicas = new short[partition.size()];
            int i = 0;
            for (short replica : partition) {
                replicas[i++] = replica;
            }
            partitions.add(new Partition(active, replicas));
        }
        return partitions;
    }

    public String toString() {
        return "PartitionInfo{numberOfReplicas=" + this.numberOfReplicas + ", partitionHosts=" + Arrays.toString(this.partitionHosts) + ", partitions=" + this.prettyPartitions() + ", tainted=" + this.tainted + '}';
    }

    private String prettyPartitions() {
        TreeMap<Integer, String> sortedPartitions = new TreeMap<Integer, String>();
        for (int i = 0; i < this.partitions.size(); ++i) {
            sortedPartitions.put(i, String.valueOf(this.partitions.get(i)));
        }
        return TopologyHelper.compressKeyRuns(sortedPartitions).toString();
    }
}

