/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.auth;

import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.auth.TBAuthType;
import com.dbeaver.model.tableau.rest.api.ServerInfo;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;

public class TBAuthProfile
implements TBObject {
    private final String id = UUID.randomUUID().toString();
    private String name;
    private String siteURL;
    private String siteId;
    private TBAuthType authType = TBAuthType.USER_PASSWORD;
    private String userName;
    private transient String userPassword;
    private String userTokenName;
    private transient String userTokenValue;
    private transient TBSession session;
    private boolean trustServerCertificate;

    @Override
    public String getId() {
        return this.id;
    }

    @Property(order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(order=2, href=true)
    public String getSiteURL() {
        return this.siteURL;
    }

    public void setSiteURL(String siteURL) {
        this.siteURL = siteURL;
    }

    @Property(order=3)
    public String getSiteId() {
        return this.siteId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Property(order=4)
    public TBAuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(TBAuthType authType) {
        this.authType = authType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getUserTokenName() {
        return this.userTokenName;
    }

    public void setUserTokenName(String userTokenName) {
        this.userTokenName = userTokenName;
    }

    public String getUserTokenValue() {
        return this.userTokenValue;
    }

    public void setUserTokenValue(String userTokenValue) {
        this.userTokenValue = userTokenValue;
    }

    public boolean isTrustServerCertificate() {
        return this.trustServerCertificate;
    }

    public void setTrustServerCertificate(boolean trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
    }

    public String testConnection(DBRProgressMonitor monitor) throws DBException {
        this.resolveCredentials();
        TBSession session = this.getSession(monitor);
        ServerInfo serverInfo = session.getServerInfo(monitor);
        return serverInfo.getProductVersion().getValue();
    }

    public TBSession getSession(DBRProgressMonitor monitor) throws DBException {
        if (this.session == null) {
            TBSession tmpSession = new TBSession(this);
            tmpSession.login(monitor);
            this.session = tmpSession;
        }
        return this.session;
    }

    public void resetSession() {
        this.session = null;
    }

    public void resolveCredentials() throws DBException {
        if (this.authType == TBAuthType.USER_PASSWORD) {
            if (this.userPassword == null) {
                this.userPassword = this.getSecretController().getPrivateSecretValue("tableau." + this.id + ".userPassword");
            }
        } else if (this.authType == TBAuthType.USER_TOKEN && this.userTokenValue == null) {
            this.userPassword = this.getSecretController().getPrivateSecretValue("tableau." + this.id + ".userToken");
        }
    }

    public void saveCredentials() throws DBException {
        if (this.authType == TBAuthType.USER_PASSWORD) {
            this.getSecretController().setPrivateSecretValue("tableau." + this.id + ".userPassword", this.userPassword);
        } else if (this.authType == TBAuthType.USER_TOKEN) {
            this.getSecretController().setPrivateSecretValue("tableau." + this.id + ".userToken", this.userTokenValue);
        }
        this.getSecretController().flushChanges();
    }

    public void deleteCredentials() throws DBException {
        if (this.authType == TBAuthType.USER_PASSWORD) {
            this.getSecretController().setPrivateSecretValue("tableau." + this.id + ".userPassword", null);
        } else if (this.authType == TBAuthType.USER_TOKEN) {
            this.getSecretController().setPrivateSecretValue("tableau." + this.id + ".userToken", null);
        }
        this.getSecretController().flushChanges();
    }

    @NotNull
    private DBSSecretController getSecretController() throws DBException {
        return DBSSecretController.getGlobalSecretController();
    }

    @Nullable
    public String getDescription() {
        return this.siteURL;
    }

    public String toString() {
        return this.getName();
    }
}

