/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.application.DBeaverApplicationAdvanced;
import com.dbeaver.application.EnterpriseActionBarAdvisor;
import com.dbeaver.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.application.internal.AdvancedAppMessages;
import com.dbeaver.ee.qm.internal.QMPluginService;
import com.dbeaver.model.DBPApplicationEAP;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchWindowAdvisor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class EnterpriseWorkbenchWindowAdvisor
extends ApplicationWorkbenchWindowAdvisor {
    private static final String ECLIPSE_SECURITY_PLUGIN = "org.eclipse.equinox.security";
    private static final Log log = Log.getLog(EnterpriseWorkbenchWindowAdvisor.class);

    public EnterpriseWorkbenchWindowAdvisor(EnterpriseWorkbenchAdvisor advisor, IWorkbenchWindowConfigurer configurer) {
        super((ApplicationWorkbenchAdvisor)advisor, configurer);
        ConfigurationScope.INSTANCE.getNode(ECLIPSE_SECURITY_PLUGIN).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new PreferenceChangeListener());
    }

    public void postWindowOpen() {
        new AbstractJob("Initialize global query manager session"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    this.initGlobalQMSession(monitor);
                }
                catch (DBException e) {
                    log.error((Object)"Failed to initialize query manager", (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public void initGlobalQMSession(DBRProgressMonitor monitor) throws DBException {
                SMSession session = QMUtils.getWorkspaceSession((DBRProgressMonitor)monitor);
                SMSessionPrincipal globalPrincipal = session.getSessionPrincipal();
                String userName = globalPrincipal.getUserName();
                String qmSessionId = QMPluginService.getQmService().openSession(new QMSessionInfo(userName, globalPrincipal.getUserDomain(), RuntimeUtils.getLocalHostOrLoopback().getHostAddress()));
                DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
                if (dBPApplication instanceof DBeaverApplicationAdvanced) {
                    DBeaverApplicationAdvanced advancedApp = (DBeaverApplicationAdvanced)dBPApplication;
                    advancedApp.setQmSessionId(qmSessionId);
                }
            }
        }.schedule();
        super.postWindowOpen();
    }

    protected boolean isRunWorkbenchInitializers() {
        return super.isRunWorkbenchInitializers();
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new EnterpriseActionBarAdvisor(configurer);
    }

    @NotNull
    protected String computeProductTitle() {
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationEAP) {
            DBPApplicationEAP app = (DBPApplicationEAP)dBPApplication;
            if (app.isEarlyAccessProgram()) {
                return GeneralUtils.getProductName() + " [Early Access Program] " + GeneralUtils.getPlainVersion();
            }
            if (app.isEarlyAccessBuild()) {
                return GeneralUtils.getProductName() + " [Early Access] " + GeneralUtils.getPlainVersion();
            }
        }
        return super.computeProductTitle();
    }

    @NotNull
    private AssertionError forciblyExit(int status) {
        UIUtils.syncExec(() -> this.getWindowConfigurer().getWorkbenchConfigurer().emergencyClose());
        System.exit(status);
        return new AssertionError((Object)"not reached");
    }

    private static class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"org.eclipse.equinox.security.preferences.disabledProviders".equals(event.getKey())) {
                return;
            }
            ISecurePreferences root = SecurePreferencesFactory.getDefault().node("dbeaver");
            try {
                PreferenceChangeListener.updateSecurePreferences(root);
                DBWorkbench.getPlatformUI().showMessageBox(AdvancedAppMessages.dialog_master_password_providers_changed_update_success_title, AdvancedAppMessages.dialog_master_password_providers_changed_update_success_message, false);
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError(AdvancedAppMessages.dialog_master_password_providers_changed_update_error_title, AdvancedAppMessages.dialog_master_password_providers_changed_update_error_message, (Throwable)e);
            }
        }

        private static void updateSecurePreferences(@NotNull ISecurePreferences node) throws StorageException, IOException {
            String[] stringArray = node.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                PreferenceChangeListener.updateSecurePreferences(node.node(child));
                ++n2;
            }
            stringArray = node.keys();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                node.put(key, node.get(key, null), true);
                ++n2;
            }
            node.flush();
        }
    }
}

