/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.application.EnterpriseWorkbenchWindowAdvisor;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.security.ui.storage.DefaultPasswordProvider;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;

public class EnterpriseWorkbenchAdvisor
extends ApplicationWorkbenchAdvisor {
    private static final Log log = Log.getLog(EnterpriseWorkbenchAdvisor.class);
    private static final String SECURE_STORAGE_EP = "org.eclipse.equinox.security.secureStorage";
    private static final String DEFAULT_PASSWORD_PROVIDER_CLASS = DefaultPasswordProvider.class.getName();
    private static final String[] EXCLUDE_PREF_PAGES = new String[]{"org.eclipse.ui.preferencePages.Workbench/org.eclipse.equinox.security.ui.category"};

    public EnterpriseWorkbenchAdvisor(DBPApplication application) {
        super(application);
    }

    public void preStartup() {
        super.preStartup();
        this.filterSecurityStorage(clazz -> !clazz.equals(DEFAULT_PASSWORD_PROVIDER_CLASS));
    }

    public void postStartup() {
        super.postStartup();
    }

    @NotNull
    protected String[] getExcludedPreferencePageIds() {
        return (String[])ArrayUtils.concatArrays((Object[])super.getExcludedPreferencePageIds(), (Object[])EXCLUDE_PREF_PAGES);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new EnterpriseWorkbenchWindowAdvisor(this, configurer);
    }

    private void filterSecurityStorage(@NotNull Predicate<String> predicate) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(SECURE_STORAGE_EP);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement provider = iConfigurationElementArray[n2];
            String clazz = provider.getAttribute("class");
            if (!predicate.test(clazz)) {
                try {
                    Object token = BeanUtils.getFieldValue((Object)extensionRegistry, (String)"masterToken");
                    if (token != null) {
                        extensionRegistry.removeExtension(provider.getDeclaringExtension(), token);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Can't remove password provider " + clazz), e);
                }
            }
            ++n2;
        }
    }
}

